/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.mqtrace.SendMessageContext;
import org.apache.rocketmq.broker.processor.AbstractSendMessageProcessor;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.header.ReplyMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeaderV2;
import org.apache.rocketmq.common.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class ReplyMessageProcessor
extends AbstractSendMessageProcessor
implements NettyRequestProcessor {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");

    public ReplyMessageProcessor(BrokerController brokerController) {
        super(brokerController);
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        SendMessageContext mqtraceContext = null;
        SendMessageRequestHeader requestHeader = this.parseRequestHeader(request);
        if (requestHeader == null) {
            return null;
        }
        mqtraceContext = this.buildMsgContext(ctx, requestHeader);
        this.executeSendMessageHookBefore(ctx, request, mqtraceContext);
        RemotingCommand response = this.processReplyMessageRequest(ctx, request, mqtraceContext, requestHeader);
        this.executeSendMessageHookAfter(response, mqtraceContext);
        return response;
    }

    @Override
    protected SendMessageRequestHeader parseRequestHeader(RemotingCommand request) throws RemotingCommandException {
        SendMessageRequestHeaderV2 requestHeaderV2 = null;
        SendMessageRequestHeader requestHeader = null;
        switch (request.getCode()) {
            case 325: {
                requestHeaderV2 = (SendMessageRequestHeaderV2)request.decodeCommandCustomHeader(SendMessageRequestHeaderV2.class);
            }
            case 324: {
                requestHeader = null == requestHeaderV2 ? (SendMessageRequestHeader)request.decodeCommandCustomHeader(SendMessageRequestHeader.class) : SendMessageRequestHeaderV2.createSendMessageRequestHeaderV1((SendMessageRequestHeaderV2)requestHeaderV2);
            }
        }
        return requestHeader;
    }

    private RemotingCommand processReplyMessageRequest(ChannelHandlerContext ctx, RemotingCommand request, SendMessageContext sendMessageContext, SendMessageRequestHeader requestHeader) {
        RemotingCommand response = RemotingCommand.createResponseCommand(SendMessageResponseHeader.class);
        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
        response.setOpaque(request.getOpaque());
        response.addExtField("MSG_REGION", this.brokerController.getBrokerConfig().getRegionId());
        response.addExtField("TRACE_ON", String.valueOf(this.brokerController.getBrokerConfig().isTraceOn()));
        log.debug("receive SendReplyMessage request command, {}", (Object)request);
        long startTimstamp = this.brokerController.getBrokerConfig().getStartAcceptSendRequestTimeStamp();
        if (this.brokerController.getMessageStore().now() < startTimstamp) {
            response.setCode(1);
            response.setRemark(String.format("broker unable to service, until %s", UtilAll.timeMillisToHumanString2((long)startTimstamp)));
            return response;
        }
        response.setCode(-1);
        super.msgCheck(ctx, requestHeader, response);
        if (response.getCode() != -1) {
            return response;
        }
        byte[] body = request.getBody();
        int queueIdInt = requestHeader.getQueueId();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (queueIdInt < 0) {
            queueIdInt = ThreadLocalRandom.current().nextInt(99999999) % topicConfig.getWriteQueueNums();
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(requestHeader.getTopic());
        msgInner.setQueueId(queueIdInt);
        msgInner.setBody(body);
        msgInner.setFlag(requestHeader.getFlag().intValue());
        MessageAccessor.setProperties((Message)msgInner, (Map)MessageDecoder.string2messageProperties((String)requestHeader.getProperties()));
        msgInner.setPropertiesString(requestHeader.getProperties());
        msgInner.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        msgInner.setBornHost(ctx.channel().remoteAddress());
        msgInner.setStoreHost(this.getStoreHost());
        msgInner.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        PushReplyResult pushReplyResult = this.pushReplyMessage(ctx, requestHeader, (Message)msgInner);
        this.handlePushReplyResult(pushReplyResult, response, responseHeader, queueIdInt);
        if (this.brokerController.getBrokerConfig().isStoreReplyMessageEnable()) {
            PutMessageResult putMessageResult = this.brokerController.getMessageStore().putMessage(msgInner);
            this.handlePutMessageResult(putMessageResult, request, (MessageExt)msgInner, responseHeader, sendMessageContext, queueIdInt);
        }
        return response;
    }

    private PushReplyResult pushReplyMessage(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, Message msg) {
        ReplyMessageRequestHeader replyMessageRequestHeader = new ReplyMessageRequestHeader();
        InetSocketAddress bornAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        replyMessageRequestHeader.setBornHost(bornAddress.getAddress().getHostAddress() + ":" + bornAddress.getPort());
        InetSocketAddress storeAddress = (InetSocketAddress)this.getStoreHost();
        replyMessageRequestHeader.setStoreHost(storeAddress.getAddress().getHostAddress() + ":" + storeAddress.getPort());
        replyMessageRequestHeader.setStoreTimestamp(System.currentTimeMillis());
        replyMessageRequestHeader.setProducerGroup(requestHeader.getProducerGroup());
        replyMessageRequestHeader.setTopic(requestHeader.getTopic());
        replyMessageRequestHeader.setDefaultTopic(requestHeader.getDefaultTopic());
        replyMessageRequestHeader.setDefaultTopicQueueNums(requestHeader.getDefaultTopicQueueNums());
        replyMessageRequestHeader.setQueueId(requestHeader.getQueueId());
        replyMessageRequestHeader.setSysFlag(requestHeader.getSysFlag());
        replyMessageRequestHeader.setBornTimestamp(requestHeader.getBornTimestamp());
        replyMessageRequestHeader.setFlag(requestHeader.getFlag());
        replyMessageRequestHeader.setProperties(requestHeader.getProperties());
        replyMessageRequestHeader.setReconsumeTimes(requestHeader.getReconsumeTimes());
        replyMessageRequestHeader.setUnitMode(requestHeader.isUnitMode());
        RemotingCommand request = RemotingCommand.createRequestCommand((int)326, (CommandCustomHeader)replyMessageRequestHeader);
        request.setBody(msg.getBody());
        String senderId = (String)msg.getProperties().get("REPLY_TO_CLIENT");
        PushReplyResult pushReplyResult = new PushReplyResult(false);
        if (senderId != null) {
            Channel channel = this.brokerController.getProducerManager().findChannel(senderId);
            if (channel != null) {
                msg.getProperties().put("PUSH_REPLY_TIME", String.valueOf(System.currentTimeMillis()));
                replyMessageRequestHeader.setProperties(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
                try {
                    RemotingCommand pushResponse = this.brokerController.getBroker2Client().callClient(channel, request);
                    assert (pushResponse != null);
                    switch (pushResponse.getCode()) {
                        case 0: {
                            pushReplyResult.setPushOk(true);
                            break;
                        }
                        default: {
                            pushReplyResult.setPushOk(false);
                            pushReplyResult.setRemark("push reply message to " + senderId + "fail.");
                            log.warn("push reply message to <{}> return fail, response remark: {}", (Object)senderId, (Object)pushResponse.getRemark());
                            break;
                        }
                    }
                }
                catch (InterruptedException | RemotingException e) {
                    pushReplyResult.setPushOk(false);
                    pushReplyResult.setRemark("push reply message to " + senderId + "fail.");
                    log.warn("push reply message to <{}> fail. {}", new Object[]{senderId, channel, e});
                }
            } else {
                pushReplyResult.setPushOk(false);
                pushReplyResult.setRemark("push reply message fail, channel of <" + senderId + "> not found.");
                log.warn(pushReplyResult.getRemark());
            }
        } else {
            log.warn("REPLY_TO_CLIENT is null, can not reply message");
            pushReplyResult.setPushOk(false);
            pushReplyResult.setRemark("reply message properties[REPLY_TO_CLIENT] is null");
        }
        return pushReplyResult;
    }

    private void handlePushReplyResult(PushReplyResult pushReplyResult, RemotingCommand response, SendMessageResponseHeader responseHeader, int queueIdInt) {
        if (!pushReplyResult.isPushOk()) {
            response.setCode(1);
            response.setRemark(pushReplyResult.getRemark());
        } else {
            response.setCode(0);
            response.setRemark(null);
            responseHeader.setMsgId("0");
            responseHeader.setQueueId(Integer.valueOf(queueIdInt));
            responseHeader.setQueueOffset(Long.valueOf(0L));
        }
    }

    private void handlePutMessageResult(PutMessageResult putMessageResult, RemotingCommand request, MessageExt msg, SendMessageResponseHeader responseHeader, SendMessageContext sendMessageContext, int queueIdInt) {
        if (putMessageResult == null) {
            log.warn("process reply message, store putMessage return null");
            return;
        }
        boolean putOk = false;
        switch (putMessageResult.getPutMessageStatus()) {
            case PUT_OK: 
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: 
            case SLAVE_NOT_AVAILABLE: {
                putOk = true;
                break;
            }
            case CREATE_MAPEDFILE_FAILED: {
                log.warn("create mapped file failed, server is busy or broken.");
                break;
            }
            case MESSAGE_ILLEGAL: {
                log.warn("the message is illegal, maybe msg body or properties length not matched. msg body length limit {}B.", (Object)this.brokerController.getMessageStoreConfig().getMaxMessageSize());
                break;
            }
            case PROPERTIES_SIZE_EXCEEDED: {
                log.warn("the message is illegal, maybe msg properties length limit 32KB.");
                break;
            }
            case SERVICE_NOT_AVAILABLE: {
                log.warn("service not available now. It may be caused by one of the following reasons: the broker's disk is full, messages are put to the slave, message store has been shut down, etc.");
                break;
            }
            case OS_PAGECACHE_BUSY: {
                log.warn("[PC_SYNCHRONIZED]broker busy, start flow control for a while");
                break;
            }
            case UNKNOWN_ERROR: {
                log.warn("UNKNOWN_ERROR");
                break;
            }
            default: {
                log.warn("UNKNOWN_ERROR DEFAULT");
            }
        }
        String owner = (String)request.getExtFields().get("Owner");
        if (putOk) {
            this.brokerController.getBrokerStatsManager().incTopicPutNums(msg.getTopic(), putMessageResult.getAppendMessageResult().getMsgNum(), 1);
            this.brokerController.getBrokerStatsManager().incTopicPutSize(msg.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
            this.brokerController.getBrokerStatsManager().incBrokerPutNums(putMessageResult.getAppendMessageResult().getMsgNum());
            responseHeader.setMsgId(putMessageResult.getAppendMessageResult().getMsgId());
            responseHeader.setQueueId(Integer.valueOf(queueIdInt));
            responseHeader.setQueueOffset(Long.valueOf(putMessageResult.getAppendMessageResult().getLogicsOffset()));
            if (this.hasSendMessageHook()) {
                sendMessageContext.setMsgId(responseHeader.getMsgId());
                sendMessageContext.setQueueId(responseHeader.getQueueId());
                sendMessageContext.setQueueOffset(responseHeader.getQueueOffset());
                int commercialBaseCount = this.brokerController.getBrokerConfig().getCommercialBaseCount();
                int wroteSize = putMessageResult.getAppendMessageResult().getWroteBytes();
                int incValue = (int)Math.ceil((double)wroteSize / 65536.0) * commercialBaseCount;
                sendMessageContext.setCommercialSendStats(BrokerStatsManager.StatsType.SEND_SUCCESS);
                sendMessageContext.setCommercialSendTimes(incValue);
                sendMessageContext.setCommercialSendSize(wroteSize);
                sendMessageContext.setCommercialOwner(owner);
            }
        } else if (this.hasSendMessageHook()) {
            int wroteSize = request.getBody().length;
            int incValue = (int)Math.ceil((double)wroteSize / 65536.0);
            sendMessageContext.setCommercialSendStats(BrokerStatsManager.StatsType.SEND_FAILURE);
            sendMessageContext.setCommercialSendTimes(incValue);
            sendMessageContext.setCommercialSendSize(wroteSize);
            sendMessageContext.setCommercialOwner(owner);
        }
    }

    class PushReplyResult {
        boolean pushOk;
        String remark;

        public PushReplyResult(boolean pushOk) {
            this.pushOk = pushOk;
            this.remark = "";
        }

        public boolean isPushOk() {
            return this.pushOk;
        }

        public void setPushOk(boolean pushOk) {
            this.pushOk = pushOk;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }
}

