/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.transaction;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.example.transaction.TransactionListenerImpl;

public class TransactionProducer {
    public static void main(String[] args) throws MQClientException, InterruptedException {
        int i;
        TransactionListenerImpl transactionListener = new TransactionListenerImpl();
        TransactionMQProducer producer = new TransactionMQProducer("please_rename_unique_group_name");
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(2, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2000), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("client-transaction-msg-check-thread");
                return thread;
            }
        });
        producer.setExecutorService((ExecutorService)executorService);
        producer.setTransactionListener((TransactionListener)transactionListener);
        producer.start();
        String[] tags = new String[]{"TagA", "TagB", "TagC", "TagD", "TagE"};
        for (i = 0; i < 10; ++i) {
            try {
                Message msg = new Message("TopicTest1234", tags[i % tags.length], "KEY" + i, ("Hello RocketMQ " + i).getBytes("UTF-8"));
                TransactionSendResult sendResult = producer.sendMessageInTransaction(msg, null);
                System.out.printf("%s%n", sendResult);
                Thread.sleep(10L);
                continue;
            }
            catch (UnsupportedEncodingException | MQClientException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < 100000; ++i) {
            Thread.sleep(1000L);
        }
        producer.shutdown();
    }
}

