/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.openmessaging;

import io.openmessaging.BytesMessage;
import io.openmessaging.Message;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.OMS;
import io.openmessaging.consumer.PullConsumer;
import io.openmessaging.producer.Producer;
import io.openmessaging.producer.SendResult;

public class SimplePullConsumer {
    public static void main(String[] args) {
        MessagingAccessPoint messagingAccessPoint = OMS.getMessagingAccessPoint((String)"oms:rocketmq://localhost:9876/default:default");
        messagingAccessPoint.startup();
        Producer producer = messagingAccessPoint.createProducer();
        PullConsumer consumer = messagingAccessPoint.createPullConsumer(OMS.newKeyValue().put("CONSUMER_ID", "OMS_CONSUMER"));
        messagingAccessPoint.startup();
        System.out.printf("MessagingAccessPoint startup OK%n", new Object[0]);
        String queueName = "TopicTest";
        producer.startup();
        BytesMessage msg = producer.createBytesMessage("TopicTest", "Hello Open Messaging".getBytes());
        SendResult sendResult = producer.send((Message)msg);
        System.out.printf("Send Message OK. MsgId: %s%n", sendResult.messageId());
        producer.shutdown();
        consumer.attachQueue("TopicTest");
        consumer.startup();
        System.out.printf("Consumer startup OK%n", new Object[0]);
        boolean stop = false;
        while (!stop) {
            Message message = consumer.receive();
            if (message != null) {
                String msgId = message.sysHeaders().getString("MESSAGE_ID");
                System.out.printf("Received one message: %s%n", msgId);
                consumer.ack(msgId);
                if (stop) continue;
                stop = msgId.equalsIgnoreCase(sendResult.messageId());
                continue;
            }
            System.out.printf("Return without any message%n", new Object[0]);
        }
        consumer.shutdown();
        messagingAccessPoint.shutdown();
    }
}

