/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.openmessaging;

import io.openmessaging.BytesMessage;
import io.openmessaging.Future;
import io.openmessaging.FutureListener;
import io.openmessaging.Message;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.OMS;
import io.openmessaging.producer.Producer;
import io.openmessaging.producer.SendResult;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;

public class SimpleProducer {
    public static void main(String[] args) {
        MessagingAccessPoint messagingAccessPoint = OMS.getMessagingAccessPoint((String)"oms:rocketmq://localhost:9876/default:default");
        Producer producer = messagingAccessPoint.createProducer();
        messagingAccessPoint.startup();
        System.out.printf("MessagingAccessPoint startup OK%n", new Object[0]);
        producer.startup();
        System.out.printf("Producer startup OK%n", new Object[0]);
        BytesMessage message = producer.createBytesMessage("OMS_HELLO_TOPIC", "OMS_HELLO_BODY".getBytes(Charset.forName("UTF-8")));
        SendResult sendResult = producer.send((Message)message);
        System.out.printf("Send async message OK, msgId: %s%n", sendResult.messageId());
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Future result = producer.sendAsync((Message)producer.createBytesMessage("OMS_HELLO_TOPIC", "OMS_HELLO_BODY".getBytes(Charset.forName("UTF-8"))));
        result.addListener((FutureListener)new FutureListener<SendResult>(){

            public void operationComplete(Future<SendResult> future) {
                if (future.getThrowable() != null) {
                    System.out.printf("Send async message Failed, error: %s%n", future.getThrowable().getMessage());
                } else {
                    System.out.printf("Send async message OK, msgId: %s%n", ((SendResult)future.get()).messageId());
                }
                countDownLatch.countDown();
            }
        });
        producer.sendOneway((Message)producer.createBytesMessage("OMS_HELLO_TOPIC", "OMS_HELLO_BODY".getBytes(Charset.forName("UTF-8"))));
        System.out.printf("Send oneway message OK%n", new Object[0]);
        try {
            countDownLatch.await();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        producer.shutdown();
    }
}

