/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.namespace;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.common.message.MessageQueue;

public class PullConsumerWithNamespace {
    private static final Map<MessageQueue, Long> OFFSE_TABLE = new HashMap<MessageQueue, Long>();

    public static void main(String[] args) throws Exception {
        DefaultMQPullConsumer pullConsumer = new DefaultMQPullConsumer("InstanceTest", "cidTest");
        pullConsumer.setNamesrvAddr("127.0.0.1:9876");
        pullConsumer.start();
        Set mqs = pullConsumer.fetchSubscribeMessageQueues("topicTest");
        block8: for (MessageQueue mq : mqs) {
            System.out.printf("Consume from the topic: %s, queue: %s%n", mq.getTopic(), mq);
            while (true) {
                try {
                    while (true) {
                        PullResult pullResult = pullConsumer.pullBlockIfNotFound(mq, null, PullConsumerWithNamespace.getMessageQueueOffset(mq), 32);
                        System.out.printf("%s%n", pullResult);
                        PullConsumerWithNamespace.putMessageQueueOffset(mq, pullResult.getNextBeginOffset());
                        switch (pullResult.getPullStatus()) {
                            case FOUND: {
                                PullConsumerWithNamespace.dealWithPullResult(pullResult);
                                break;
                            }
                            case NO_MATCHED_MSG: {
                                break;
                            }
                            case NO_NEW_MSG: {
                                continue block8;
                            }
                            case OFFSET_ILLEGAL: {
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        pullConsumer.shutdown();
    }

    private static long getMessageQueueOffset(MessageQueue mq) {
        Long offset = OFFSE_TABLE.get(mq);
        if (offset != null) {
            return offset;
        }
        return 0L;
    }

    private static void dealWithPullResult(PullResult pullResult) {
        if (null == pullResult || pullResult.getMsgFoundList().isEmpty()) {
            return;
        }
        pullResult.getMsgFoundList().stream().forEach(msg -> System.out.printf("Topic is:%s, msgId is:%s%n", msg.getTopic(), msg.getMsgId()));
    }

    private static void putMessageQueueOffset(MessageQueue mq, long offset) {
        OFFSE_TABLE.put(mq, offset);
    }
}

