/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.batch;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.message.Message;

class ListSplitter
implements Iterator<List<Message>> {
    private int sizeLimit = 1000000;
    private final List<Message> messages;
    private int currIndex;

    public ListSplitter(List<Message> messages) {
        this.messages = messages;
    }

    @Override
    public boolean hasNext() {
        return this.currIndex < this.messages.size();
    }

    @Override
    public List<Message> next() {
        int nextIndex;
        int totalSize = 0;
        for (nextIndex = this.currIndex; nextIndex < this.messages.size(); ++nextIndex) {
            Message message = this.messages.get(nextIndex);
            int tmpSize = message.getTopic().length() + message.getBody().length;
            Map properties = message.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                tmpSize += ((String)entry.getKey()).length() + ((String)entry.getValue()).length();
            }
            if ((tmpSize += 20) > this.sizeLimit) {
                if (nextIndex - this.currIndex != 0) break;
                ++nextIndex;
                break;
            }
            if (tmpSize + totalSize > this.sizeLimit) break;
            totalSize += tmpSize;
        }
        List<Message> subList = this.messages.subList(this.currIndex, nextIndex);
        this.currIndex = nextIndex;
        return subList;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not allowed to remove");
    }
}

