/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestFilePositionCount;
import org.apache.ratis.io.StandardWriteOption;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.netty.NettyDataStreamUtils;
import org.apache.ratis.netty.NettyUtils;
import org.apache.ratis.netty.client.NettyClientReplies;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.DataStreamPacket;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInboundHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ratis.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.ratis.thirdparty.io.netty.util.concurrent.ScheduledFuture;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReferenceCountedObject;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientStreamRpc
implements DataStreamClientRpc {
    public static final Logger LOG = LoggerFactory.getLogger(NettyClientStreamRpc.class);
    private final String name;
    private final Connection connection;
    private final NettyClientReplies replies = new NettyClientReplies();
    private final TimeDuration requestTimeout;
    private final TimeDuration closeTimeout;
    private final int flushRequestCountMin;
    private final SizeInBytes flushRequestBytesMin;
    private final OutstandingRequests outstandingRequests = new OutstandingRequests();
    static final MessageToMessageEncoder<DataStreamRequestByteBuffer> ENCODER = new Encoder();
    static final MessageToMessageEncoder<DataStreamRequestFilePositionCount> ENCODER_FILE_POSITION_COUNT = new EncoderFilePositionCount();
    static final MessageToMessageEncoder<ByteBuffer> ENCODER_BYTE_BUFFER = new EncoderByteBuffer();

    public NettyClientStreamRpc(RaftPeer server, TlsConf tlsConf, RaftProperties properties) {
        this.name = JavaUtils.getClassSimpleName(this.getClass()) + "->" + server;
        this.requestTimeout = RaftClientConfigKeys.DataStream.requestTimeout((RaftProperties)properties);
        this.closeTimeout = this.requestTimeout.multiply(2.0);
        this.flushRequestCountMin = RaftClientConfigKeys.DataStream.flushRequestCountMin((RaftProperties)properties);
        this.flushRequestBytesMin = RaftClientConfigKeys.DataStream.flushRequestBytesMin((RaftProperties)properties);
        InetSocketAddress address = NetUtils.createSocketAddr((String)server.getDataStreamAddress());
        SslContext sslContext = NettyUtils.buildSslContextForClient(tlsConf);
        this.connection = new Connection(address, WorkerGroupGetter.newInstance(properties), () -> NettyClientStreamRpc.newChannelInitializer(address, sslContext, this.getClientHandler()));
    }

    private ChannelInboundHandler getClientHandler() {
        return new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (!(msg instanceof DataStreamReply)) {
                    LOG.error("{}: unexpected message {}", (Object)this, msg.getClass());
                    return;
                }
                DataStreamReply reply = (DataStreamReply)msg;
                LOG.debug("{}: read {}", (Object)this, (Object)reply);
                ClientInvocationId clientInvocationId = ClientInvocationId.valueOf((ClientId)reply.getClientId(), (long)reply.getStreamId());
                NettyClientReplies.ReplyMap replyMap = NettyClientStreamRpc.this.replies.getReplyMap(clientInvocationId);
                if (replyMap == null) {
                    LOG.error("{}: {} replyMap not found for reply: {}", new Object[]{this, clientInvocationId, reply});
                    return;
                }
                try {
                    replyMap.receiveReply(reply);
                }
                catch (Throwable cause) {
                    LOG.warn(NettyClientStreamRpc.this.name + ": channelRead error:", cause);
                    replyMap.completeExceptionally(cause);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                LOG.warn(NettyClientStreamRpc.this.name + ": exceptionCaught", cause);
                ctx.close();
            }

            public void channelInactive(ChannelHandlerContext ctx) {
                if (!NettyClientStreamRpc.this.connection.isClosed()) {
                    NettyClientStreamRpc.this.connection.scheduleReconnect("channel is inactive", null);
                }
            }
        };
    }

    static ChannelInitializer<SocketChannel> newChannelInitializer(final InetSocketAddress address, final SslContext sslContext, final ChannelInboundHandler handler) {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslContext != null) {
                    p.addLast("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc(), address.getHostName(), address.getPort()));
                }
                p.addLast(new ChannelHandler[]{ENCODER});
                p.addLast(new ChannelHandler[]{ENCODER_FILE_POSITION_COUNT});
                p.addLast(new ChannelHandler[]{ENCODER_BYTE_BUFFER});
                p.addLast(new ChannelHandler[]{NettyClientStreamRpc.newDecoder()});
                p.addLast(new ChannelHandler[]{handler});
            }
        };
    }

    static ByteToMessageDecoder newDecoder() {
        return new ByteToMessageDecoder(){
            {
                this.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            }

            protected void decode(ChannelHandlerContext context, ByteBuf buf, List<Object> out) {
                Optional.ofNullable(NettyDataStreamUtils.decodeDataStreamReplyByteBuffer(buf)).ifPresent(out::add);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<DataStreamReply> streamAsync(DataStreamRequest request) {
        ChannelFuture channelFuture;
        NettyClientReplies.ReplyEntry replyEntry;
        Channel channel;
        CompletableFuture<DataStreamReply> f = new CompletableFuture<DataStreamReply>();
        ClientInvocationId clientInvocationId = ClientInvocationId.valueOf((ClientId)request.getClientId(), (long)request.getStreamId());
        boolean isClose = request.getWriteOptionList().contains(StandardWriteOption.CLOSE);
        NettyClientReplies.ReplyMap replyMap = this.replies.getReplyMap(clientInvocationId);
        NettyClientReplies.RequestEntry requestEntry = new NettyClientReplies.RequestEntry((DataStreamPacket)request);
        LOG.debug("{}: write begin {}", (Object)this, (Object)request);
        NettyClientReplies.ReplyMap replyMap2 = replyMap;
        synchronized (replyMap2) {
            channel = this.connection.getChannelUninterruptibly();
            if (channel == null) {
                f.completeExceptionally((Throwable)new AlreadyClosedException(this + ": Failed to send " + request));
                return f;
            }
            replyEntry = replyMap.submitRequest(requestEntry, isClose, f);
            Function<DataStreamRequest, ChannelFuture> writeMethod = this.outstandingRequests.write(request) ? arg_0 -> ((Channel)channel).writeAndFlush(arg_0) : arg_0 -> ((Channel)channel).write(arg_0);
            channelFuture = writeMethod.apply(request);
        }
        channelFuture.addListener(future -> {
            if (!future.isSuccess()) {
                IOException e = new IOException(this + ": Failed to send " + request + " to " + channel.remoteAddress(), future.cause());
                f.completeExceptionally(e);
                replyMap.fail(requestEntry);
                LOG.error("Channel write failed", (Throwable)e);
            } else {
                LOG.debug("{}: write after {}", (Object)this, (Object)request);
                TimeDuration timeout = isClose ? this.closeTimeout : this.requestTimeout;
                ScheduledFuture timeoutFuture = channel.eventLoop().schedule(() -> {
                    if (!f.isDone()) {
                        f.completeExceptionally((Throwable)new TimeoutIOException("Timeout " + timeout + ": Failed to send " + request + " channel: " + channel));
                        replyMap.fail(requestEntry);
                    }
                }, timeout.toLong(timeout.getUnit()), timeout.getUnit());
                replyEntry.setTimeoutFuture(timeoutFuture);
            }
        });
        return f;
    }

    public void close() {
        boolean flush = this.outstandingRequests.shouldFlush(true, 0, SizeInBytes.ZERO);
        LOG.debug("flush? {}", (Object)flush);
        if (flush) {
            Optional.ofNullable(this.connection.getChannelUninterruptibly()).map(c -> c.writeAndFlush((Object)DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER)).ifPresent(f -> f.addListener(dummy -> this.connection.close()));
        } else {
            this.connection.close();
        }
    }

    public String toString() {
        return this.name;
    }

    @ChannelHandler.Sharable
    static class EncoderByteBuffer
    extends MessageToMessageEncoder<ByteBuffer> {
        EncoderByteBuffer() {
        }

        protected void encode(ChannelHandlerContext ctx, ByteBuffer request, List<Object> out) {
            NettyDataStreamUtils.encodeByteBuffer(request, out::add);
        }
    }

    @ChannelHandler.Sharable
    static class EncoderFilePositionCount
    extends MessageToMessageEncoder<DataStreamRequestFilePositionCount> {
        EncoderFilePositionCount() {
        }

        protected void encode(ChannelHandlerContext ctx, DataStreamRequestFilePositionCount request, List<Object> out) {
            NettyDataStreamUtils.encodeDataStreamRequestFilePositionCount(request, out::add, ctx.alloc());
        }
    }

    @ChannelHandler.Sharable
    static class Encoder
    extends MessageToMessageEncoder<DataStreamRequestByteBuffer> {
        Encoder() {
        }

        protected void encode(ChannelHandlerContext context, DataStreamRequestByteBuffer request, List<Object> out) {
            NettyDataStreamUtils.encodeDataStreamRequestByteBuffer(request, out::add, context.alloc());
        }
    }

    class OutstandingRequests {
        private int count;
        private long bytes;

        OutstandingRequests() {
        }

        synchronized boolean write(DataStreamRequest request) {
            ++this.count;
            this.bytes += request.getDataLength();
            List options = request.getWriteOptionList();
            boolean isClose = options.contains(StandardWriteOption.CLOSE);
            boolean isFlush = options.contains(StandardWriteOption.FLUSH);
            boolean flush = this.shouldFlush(isClose || isFlush, NettyClientStreamRpc.this.flushRequestCountMin, NettyClientStreamRpc.this.flushRequestBytesMin);
            LOG.debug("Stream{} outstanding: count={}, bytes={}, options={}, flush? {}", new Object[]{request.getStreamId(), this.count, this.bytes, options, flush});
            return flush;
        }

        synchronized boolean shouldFlush(boolean force, int countMin, SizeInBytes bytesMin) {
            if (force || this.count >= countMin || this.bytes >= bytesMin.getSize()) {
                this.count = 0;
                this.bytes = 0L;
                return true;
            }
            return false;
        }
    }

    static class Connection {
        static final TimeDuration RECONNECT = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        private final InetSocketAddress address;
        private final WorkerGroupGetter workerGroup;
        private final Supplier<ChannelInitializer<SocketChannel>> channelInitializerSupplier;
        private final AtomicReference<Supplier<ChannelFuture>> ref;

        Connection(InetSocketAddress address, WorkerGroupGetter workerGroup, Supplier<ChannelInitializer<SocketChannel>> channelInitializerSupplier) {
            this.address = address;
            this.workerGroup = workerGroup;
            this.channelInitializerSupplier = channelInitializerSupplier;
            this.ref = new AtomicReference<MemoizedSupplier>(MemoizedSupplier.valueOf(this::connect));
        }

        ChannelFuture getChannelFuture() {
            Supplier<ChannelFuture> referenced = this.ref.get();
            return referenced != null ? referenced.get() : null;
        }

        Channel getChannelUninterruptibly() {
            ChannelFuture future = this.getChannelFuture();
            if (future == null) {
                return null;
            }
            Channel channel = future.syncUninterruptibly().channel();
            if (channel.isActive()) {
                return channel;
            }
            ChannelFuture f = this.reconnect();
            return f == null ? null : f.syncUninterruptibly().channel();
        }

        private EventLoopGroup getWorkerGroup() {
            return this.workerGroup.get();
        }

        private ChannelFuture connect() {
            return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.getWorkerGroup())).channel(NettyUtils.getSocketChannelClass(this.getWorkerGroup()))).handler((ChannelHandler)this.channelInitializerSupplier.get())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).connect((SocketAddress)this.address).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (!future.isSuccess()) {
                        this.scheduleReconnect(this + " failed", future.cause());
                    } else {
                        LOG.trace("{} succeed.", (Object)this);
                    }
                }
            });
        }

        void scheduleReconnect(String message, Throwable cause) {
            LOG.warn("{}: {}; schedule reconnecting to {} in {}", new Object[]{this, message, this.address, RECONNECT});
            if (cause != null) {
                LOG.warn("", cause);
            }
            this.getWorkerGroup().schedule(this::reconnect, RECONNECT.getDuration(), RECONNECT.getUnit());
        }

        private synchronized ChannelFuture reconnect() {
            Channel channel;
            ChannelFuture channelFuture = this.getChannelFuture();
            if (channelFuture != null && (channel = channelFuture.syncUninterruptibly().channel()).isActive()) {
                return channelFuture;
            }
            MemoizedSupplier supplier = MemoizedSupplier.valueOf(() -> MemoizedSupplier.valueOf(this::connect));
            Supplier<ChannelFuture> previous = this.ref.getAndUpdate(prev -> prev == null ? null : (Supplier)supplier.get());
            if (previous != null) {
                previous.get().channel().close();
            }
            return this.getChannelFuture();
        }

        void close() {
            Supplier previous = this.ref.getAndSet(null);
            if (previous != null) {
                ((ChannelFuture)previous.get()).channel().close().addListener(future -> this.workerGroup.shutdownGracefully());
            }
        }

        boolean isClosed() {
            return this.ref.get() == null;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass()) + "-" + this.address;
        }
    }

    private static class WorkerGroupGetter
    implements Supplier<EventLoopGroup> {
        private static final AtomicReference<CompletableFuture<ReferenceCountedObject<EventLoopGroup>>> SHARED_WORKER_GROUP = new AtomicReference();
        private final EventLoopGroup workerGroup;

        static WorkerGroupGetter newInstance(RaftProperties properties) {
            boolean shared = NettyConfigKeys.DataStream.Client.workerGroupShare(properties);
            if (shared) {
                CompletableFuture<ReferenceCountedObject> created = new CompletableFuture<ReferenceCountedObject>();
                final CompletableFuture<ReferenceCountedObject<EventLoopGroup>> current = SHARED_WORKER_GROUP.updateAndGet(g -> g != null ? g : created);
                if (current == created) {
                    created.complete(ReferenceCountedObject.wrap((Object)WorkerGroupGetter.newWorkerGroup(properties)));
                }
                return new WorkerGroupGetter((EventLoopGroup)current.join().retain()){

                    @Override
                    void shutdownGracefully() {
                        CompletableFuture returned = (CompletableFuture)SHARED_WORKER_GROUP.updateAndGet(previous -> {
                            Preconditions.assertSame((Object)current, (Object)previous, (String)"SHARED_WORKER_GROUP");
                            return ((ReferenceCountedObject)previous.join()).release() ? null : previous;
                        });
                        if (returned == null) {
                            this.get().shutdownGracefully();
                        }
                    }
                };
            }
            return new WorkerGroupGetter(WorkerGroupGetter.newWorkerGroup(properties));
        }

        static EventLoopGroup newWorkerGroup(RaftProperties properties) {
            return NettyUtils.newEventLoopGroup(JavaUtils.getClassSimpleName(NettyClientStreamRpc.class) + "-workerGroup", NettyConfigKeys.DataStream.Client.workerGroupSize(properties), NettyConfigKeys.DataStream.Client.useEpoll(properties));
        }

        private WorkerGroupGetter(EventLoopGroup workerGroup) {
            this.workerGroup = workerGroup;
        }

        @Override
        public final EventLoopGroup get() {
            return this.workerGroup;
        }

        void shutdownGracefully() {
            this.workerGroup.shutdownGracefully();
        }
    }
}

