/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;

public interface IOUtils {
    public static InterruptedIOException toInterruptedIOException(String message, InterruptedException e) {
        InterruptedIOException iioe = new InterruptedIOException(message);
        iioe.initCause(e);
        return iioe;
    }

    public static IOException asIOException(Throwable t2) {
        Objects.requireNonNull(t2, "t == null");
        return t2 instanceof IOException ? (IOException)t2 : new IOException(t2);
    }

    public static IOException toIOException(ExecutionException e) {
        Throwable cause = e.getCause();
        return cause != null ? IOUtils.asIOException(cause) : new IOException(e);
    }

    public static <T> T getFromFuture(CompletableFuture<T> future, Supplier<Object> name) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException(name.get() + " interrupted.", e);
        }
        catch (ExecutionException e) {
            throw IOUtils.toIOException(e);
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException(JavaUtils.unwrapCompletionException(e));
        }
    }

    public static <T> T getFromFuture(CompletableFuture<T> future, Supplier<Object> name, TimeDuration timeout) throws IOException {
        try {
            return future.get(timeout.getDuration(), timeout.getUnit());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException(name.get() + " interrupted.", e);
        }
        catch (ExecutionException e) {
            throw IOUtils.toIOException(e);
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException(JavaUtils.unwrapCompletionException(e));
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException("Timeout " + timeout + ": " + name.get(), e);
        }
    }

    public static boolean shouldReconnect(Throwable e) {
        return ReflectionUtils.isInstance(e, SocketException.class, SocketTimeoutException.class, ClosedChannelException.class, EOFException.class, AlreadyClosedException.class);
    }

    public static void readFully(InputStream in, int buffSize) throws IOException {
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf);
        while (bytesRead >= 0) {
            bytesRead = in.read(buf);
        }
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                int read = len - toRead;
                throw new EOFException("Premature EOF: read length is " + len + " but encountered EOF at " + read);
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void writeFully(FileChannel fc, ByteBuffer buf, long offset) throws IOException {
        do {
            offset += (long)fc.write(buf, offset);
        } while (buf.remaining() > 0);
    }

    public static long preallocate(FileChannel fc, long size, ByteBuffer fill) throws IOException {
        long allocated;
        int n;
        Preconditions.assertSame(0L, fill.position(), "fill.position");
        Preconditions.assertSame(fill.capacity(), fill.limit(), "fill.limit");
        int remaining = fill.remaining();
        for (allocated = 0L; allocated < size; allocated += (long)n) {
            long required = size - allocated;
            n = (long)remaining < required ? remaining : Math.toIntExact(required);
            ByteBuffer buffer = fill.slice();
            buffer.limit(n);
            IOUtils.writeFully(fc, buffer, fc.size());
        }
        return allocated;
    }

    public static void skipFully(InputStream in, long len) throws IOException {
        long ret;
        for (long amt = len; amt > 0L; amt -= ret) {
            ret = in.skip(amt);
            if (ret != 0L) continue;
            int b = in.read();
            if (b == -1) {
                throw new EOFException("Premature EOF from inputStream after skipping " + (len - amt) + " byte(s).");
            }
            ret = 1L;
        }
    }

    public static void cleanup(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing " + c, e);
            }
        }
    }

    public static byte[] object2Bytes(Object obj) {
        return ProtoUtils.writeObject2ByteString(obj).toByteArray();
    }

    public static <T> T bytes2Object(byte[] bytes, Class<T> clazz) {
        return IOUtils.readObject(new ByteArrayInputStream(bytes), clazz);
    }

    public static <T> T readObject(InputStream in, Class<T> clazz) {
        Object obj;
        try (ObjectInputStream oin = new ObjectInputStream(in);){
            obj = oin.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Failed to readObject for class " + clazz, e);
        }
        try {
            return clazz.cast(obj);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Failed to cast to " + clazz + ", object=" + (obj instanceof Throwable ? StringUtils.stringifyException((Throwable)obj) : obj), e);
        }
    }
}

