/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectoryImpl;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.server.storage.RaftStorageMetadataFile;
import org.apache.ratis.server.storage.RaftStorageMetadataFileImpl;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;

public class RaftStorageImpl
implements RaftStorage {
    private final RaftStorageDirectoryImpl storageDir;
    private final RaftStorage.StartupOption startupOption;
    private final RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy;
    private volatile RaftStorageDirectoryImpl.StorageState state = RaftStorageDirectoryImpl.StorageState.UNINITIALIZED;
    private final MetaFile metaFile = new MetaFile();

    RaftStorageImpl(File dir, SizeInBytes freeSpaceMin, RaftStorage.StartupOption option, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy) {
        LOG.debug("newRaftStorage: {}, freeSpaceMin={}, option={}, logCorruptionPolicy={}", new Object[]{dir, freeSpaceMin, option, logCorruptionPolicy});
        this.storageDir = new RaftStorageDirectoryImpl(dir, freeSpaceMin);
        this.logCorruptionPolicy = Optional.ofNullable(logCorruptionPolicy).orElseGet(RaftServerConfigKeys.Log.CorruptionPolicy::getDefault);
        this.startupOption = option;
    }

    @Override
    public void initialize() throws IOException {
        try {
            if (this.startupOption == RaftStorage.StartupOption.FORMAT) {
                if (this.storageDir.analyzeStorage(false) == RaftStorageDirectoryImpl.StorageState.NON_EXISTENT) {
                    throw new IOException("Cannot format " + this.storageDir);
                }
                this.storageDir.lock();
                this.format();
                this.state = this.storageDir.analyzeStorage(false);
            } else {
                this.state = this.analyzeAndRecoverStorage(true);
            }
        }
        catch (Throwable t2) {
            RaftStorageImpl.unlockOnFailure(this.storageDir);
            throw t2;
        }
        if (this.state != RaftStorageDirectoryImpl.StorageState.NORMAL) {
            RaftStorageImpl.unlockOnFailure(this.storageDir);
            throw new IOException("Failed to load " + this.storageDir + ": " + (Object)((Object)this.state));
        }
    }

    static void unlockOnFailure(RaftStorageDirectoryImpl dir) {
        try {
            dir.unlock();
        }
        catch (Throwable t2) {
            LOG.warn("Failed to unlock " + dir, t2);
        }
    }

    RaftStorageDirectoryImpl.StorageState getState() {
        return this.state;
    }

    @Override
    public RaftServerConfigKeys.Log.CorruptionPolicy getLogCorruptionPolicy() {
        return this.logCorruptionPolicy;
    }

    private void format() throws IOException {
        this.storageDir.clearDirectory();
        this.metaFile.set(this.storageDir.getMetaFile()).persist(RaftStorageMetadata.getDefault());
        LOG.info("Storage directory {} has been successfully formatted.", (Object)this.storageDir.getRoot());
    }

    private void cleanMetaTmpFile() throws IOException {
        Files.deleteIfExists(this.storageDir.getMetaTmpFile().toPath());
    }

    private RaftStorageDirectoryImpl.StorageState analyzeAndRecoverStorage(boolean toLock) throws IOException {
        RaftStorageDirectoryImpl.StorageState storageState = this.storageDir.analyzeStorage(toLock);
        if (storageState != RaftStorageDirectoryImpl.StorageState.NON_EXISTENT) {
            this.cleanMetaTmpFile();
        }
        if (storageState == RaftStorageDirectoryImpl.StorageState.NORMAL) {
            File f = this.storageDir.getMetaFile();
            if (!f.exists()) {
                throw new FileNotFoundException("Metadata file " + f + " does not exists.");
            }
            RaftStorageMetadata metadata = this.metaFile.set(f).getMetadata();
            LOG.info("Read {} from {}", (Object)metadata, (Object)f);
            return RaftStorageDirectoryImpl.StorageState.NORMAL;
        }
        if (storageState == RaftStorageDirectoryImpl.StorageState.NOT_FORMATTED && this.storageDir.isCurrentEmpty()) {
            this.format();
            return RaftStorageDirectoryImpl.StorageState.NORMAL;
        }
        return storageState;
    }

    @Override
    public RaftStorageDirectoryImpl getStorageDir() {
        return this.storageDir;
    }

    @Override
    public void close() throws IOException {
        this.storageDir.unlock();
    }

    @Override
    public RaftStorageMetadataFile getMetadataFile() {
        return this.metaFile.get();
    }

    public void writeRaftConfiguration(RaftProtos.LogEntryProto conf) {
        File confFile = this.storageDir.getMetaConfFile();
        try (FileOutputStream fio = new FileOutputStream(confFile);){
            conf.writeTo(fio);
        }
        catch (Exception e) {
            LOG.error("Failed writing configuration to file:" + confFile, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RaftConfiguration readRaftConfiguration() {
        File confFile = this.storageDir.getMetaConfFile();
        try (FileInputStream fio = new FileInputStream(confFile);){
            RaftProtos.LogEntryProto confProto = ((RaftProtos.LogEntryProto.Builder)RaftProtos.LogEntryProto.newBuilder().mergeFrom(fio)).build();
            RaftConfiguration raftConfiguration = LogProtoUtils.toRaftConfiguration(confProto);
            return raftConfiguration;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error("Failed reading configuration from file:" + confFile, e);
            return null;
        }
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.getStorageDir();
    }

    static class MetaFile {
        private final AtomicReference<RaftStorageMetadataFileImpl> ref = new AtomicReference();

        MetaFile() {
        }

        RaftStorageMetadataFile get() {
            return this.ref.get();
        }

        RaftStorageMetadataFile set(File file) {
            RaftStorageMetadataFileImpl impl = new RaftStorageMetadataFileImpl(file);
            this.ref.set(impl);
            return impl;
        }
    }
}

