/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.function.CheckedFunction;

public interface SegmentedRaftLogFormat {
    public static int getHeaderLength() {
        return Internal.HEADER_BYTES.length;
    }

    public static int matchHeader(byte[] bytes, int offset, int length) {
        Preconditions.assertTrue(length <= SegmentedRaftLogFormat.getHeaderLength());
        for (int i = 0; i < length; ++i) {
            if (bytes[offset + i] == Internal.HEADER_BYTES[i]) continue;
            return i;
        }
        return length;
    }

    public static <T> T applyHeaderTo(CheckedFunction<byte[], T, IOException> function) throws IOException {
        T t2 = function.apply(Internal.HEADER_BYTES);
        Internal.assertHeader();
        return t2;
    }

    public static byte getTerminator() {
        return 0;
    }

    public static boolean isTerminator(byte b) {
        return b == 0;
    }

    public static boolean isTerminator(byte[] bytes, int offset, int length) {
        return SegmentedRaftLogFormat.indexOfNonTerminator(bytes, offset, length) == -1;
    }

    public static int indexOfNonTerminator(byte[] bytes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (SegmentedRaftLogFormat.isTerminator(bytes[offset + i])) continue;
            return i;
        }
        return -1;
    }

    public static class Internal {
        private static final byte[] HEADER_BYTES = "RaftLog1".getBytes(StandardCharsets.UTF_8);
        private static final byte[] HEADER_BYTES_CLONE = (byte[])HEADER_BYTES.clone();
        private static final byte TERMINATOR_BYTE = 0;

        private static void assertHeader() {
            Preconditions.assertTrue(Arrays.equals(HEADER_BYTES, HEADER_BYTES_CLONE));
        }
    }
}

