/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.server.metrics.RaftServerMetrics;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;

public final class RaftServerMetricsImpl
extends RatisMetrics
implements RaftServerMetrics {
    public static final String RATIS_SERVER_METRICS = "server";
    public static final String RATIS_SERVER_METRICS_DESC = "Metrics for Raft server";
    public static final String FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC = "%s_lastHeartbeatElapsedTime";
    public static final String FOLLOWER_APPEND_ENTRIES_LATENCY = "follower_append_entry_latency";
    public static final String LEADER_METRIC_PEER_COMMIT_INDEX = "%s_peerCommitIndex";
    public static final String RAFT_CLIENT_READ_REQUEST = "clientReadRequest";
    public static final String RAFT_CLIENT_STALE_READ_REQUEST = "clientStaleReadRequest";
    public static final String RAFT_CLIENT_WRITE_REQUEST = "clientWriteRequest";
    public static final String RAFT_CLIENT_WATCH_REQUEST = "clientWatch%sRequest";
    public static final String REQUEST_QUEUE_LIMIT_HIT_COUNTER = "numRequestQueueLimitHits";
    public static final String REQUEST_BYTE_SIZE_LIMIT_HIT_COUNTER = "numRequestsByteSizeLimitHits";
    public static final String RESOURCE_LIMIT_HIT_COUNTER = "numResourceLimitHits";
    public static final String REQUEST_QUEUE_SIZE = "numPendingRequestInQueue";
    public static final String REQUEST_MEGA_BYTE_SIZE = "numPendingRequestMegaByteSize";
    public static final String RETRY_CACHE_ENTRY_COUNT_METRIC = "retryCacheEntryCount";
    public static final String RETRY_CACHE_HIT_COUNT_METRIC = "retryCacheHitCount";
    public static final String RETRY_CACHE_HIT_RATE_METRIC = "retryCacheHitRate";
    public static final String RETRY_CACHE_MISS_COUNT_METRIC = "retryCacheMissCount";
    public static final String RETRY_CACHE_MISS_RATE_METRIC = "retryCacheMissRate";
    public static final String RATIS_SERVER_FAILED_CLIENT_STALE_READ_COUNT = "numFailedClientStaleReadOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_READ_COUNT = "numFailedClientReadOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_WRITE_COUNT = "numFailedClientWriteOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_WATCH_COUNT = "numFailedClientWatchOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_STREAM_COUNT = "numFailedClientStreamOnServer";
    public static final String RATIS_SERVER_INSTALL_SNAPSHOT_COUNT = "numInstallSnapshot";
    private final LongCounter numRequestQueueLimitHits = this.getRegistry().counter("numRequestQueueLimitHits");
    private final LongCounter numRequestsByteSizeLimitHits = this.getRegistry().counter("numRequestsByteSizeLimitHits");
    private final LongCounter numResourceLimitHits = this.getRegistry().counter("numResourceLimitHits");
    private final LongCounter numFailedClientStaleRead = this.getRegistry().counter("numFailedClientStaleReadOnServer");
    private final LongCounter numFailedClientRead = this.getRegistry().counter("numFailedClientReadOnServer");
    private final LongCounter numFailedClientWrite = this.getRegistry().counter("numFailedClientWriteOnServer");
    private final LongCounter numFailedClientWatch = this.getRegistry().counter("numFailedClientWatchOnServer");
    private final LongCounter numFailedClientStream = this.getRegistry().counter("numFailedClientStreamOnServer");
    private final LongCounter numInstallSnapshot = this.getRegistry().counter("numInstallSnapshot");
    private final Timekeeper readTimer = this.getRegistry().timer("clientReadRequest");
    private final Timekeeper staleReadTimer = this.getRegistry().timer("clientStaleReadRequest");
    private final Timekeeper writeTimer = this.getRegistry().timer("clientWriteRequest");
    private final Map<RaftProtos.ReplicationLevel, Timekeeper> watchTimers = RaftServerMetricsImpl.newTimerMap(RaftProtos.ReplicationLevel.class, replication -> this.getRegistry().timer(String.format(RAFT_CLIENT_WATCH_REQUEST, RaftClientRequest.Type.toString(replication))));
    private final Function<Boolean, Timekeeper> followerAppendEntryLatency = this.newHeartbeatTimer("follower_append_entry_latency");
    private final Map<RaftPeerId, Long> followerLastHeartbeatElapsedTimeMap = new ConcurrentHashMap<RaftPeerId, Long>();
    private final Supplier<Function<RaftPeerId, RaftProtos.CommitInfoProto>> commitInfoCache;
    private static final Map<RaftGroupMemberId, RaftServerMetricsImpl> METRICS = new ConcurrentHashMap<RaftGroupMemberId, RaftServerMetricsImpl>();
    private static final Map<RaftPeerId, String> PEER_COMMIT_INDEX_GAUGE_KEYS = new ConcurrentHashMap<RaftPeerId, String>();

    static String getPeerCommitIndexGaugeKey(RaftPeerId serverId) {
        return PEER_COMMIT_INDEX_GAUGE_KEYS.computeIfAbsent(serverId, key -> String.format(LEADER_METRIC_PEER_COMMIT_INDEX, key));
    }

    public static RaftServerMetricsImpl computeIfAbsentRaftServerMetrics(RaftGroupMemberId serverId, Supplier<Function<RaftPeerId, RaftProtos.CommitInfoProto>> commitInfoCache, Supplier<RetryCache.Statistics> retryCacheStatistics) {
        return METRICS.computeIfAbsent(serverId, key -> new RaftServerMetricsImpl(serverId, commitInfoCache, retryCacheStatistics));
    }

    public static void removeRaftServerMetrics(RaftGroupMemberId serverId) {
        METRICS.remove(serverId);
    }

    public RaftServerMetricsImpl(RaftGroupMemberId serverId, Supplier<Function<RaftPeerId, RaftProtos.CommitInfoProto>> commitInfoCache, Supplier<RetryCache.Statistics> retryCacheStatistics) {
        super(RaftServerMetricsImpl.createRegistry(serverId.toString()));
        this.commitInfoCache = commitInfoCache;
        this.addPeerCommitIndexGauge(serverId.getPeerId());
        this.addRetryCacheMetric(retryCacheStatistics);
    }

    public LongCounter getNumRequestQueueLimitHits() {
        return this.numRequestQueueLimitHits;
    }

    public LongCounter getNumRequestsByteSizeLimitHits() {
        return this.numRequestsByteSizeLimitHits;
    }

    public LongCounter getNumResourceLimitHits() {
        return this.numResourceLimitHits;
    }

    public LongCounter getNumFailedClientStaleRead() {
        return this.numFailedClientStaleRead;
    }

    public LongCounter getNumInstallSnapshot() {
        return this.numInstallSnapshot;
    }

    private static RatisMetricRegistry createRegistry(String serverId) {
        return RaftServerMetricsImpl.create(new MetricRegistryInfo(serverId, "ratis", RATIS_SERVER_METRICS, RATIS_SERVER_METRICS_DESC));
    }

    private void addRetryCacheMetric(Supplier<RetryCache.Statistics> retryCacheStatistics) {
        this.getRegistry().gauge(RETRY_CACHE_ENTRY_COUNT_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$3((Supplier)retryCacheStatistics));
        this.getRegistry().gauge(RETRY_CACHE_HIT_COUNT_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$5((Supplier)retryCacheStatistics));
        this.getRegistry().gauge(RETRY_CACHE_HIT_RATE_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$7((Supplier)retryCacheStatistics));
        this.getRegistry().gauge(RETRY_CACHE_MISS_COUNT_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$9((Supplier)retryCacheStatistics));
        this.getRegistry().gauge(RETRY_CACHE_MISS_RATE_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$11((Supplier)retryCacheStatistics));
    }

    public void addFollower(RaftPeerId followerName) {
        String followerHbMetricKey = String.format(FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC, followerName);
        this.followerLastHeartbeatElapsedTimeMap.put(followerName, 0L);
        this.getRegistry().gauge(followerHbMetricKey, () -> () -> this.followerLastHeartbeatElapsedTimeMap.get(followerName));
        this.addPeerCommitIndexGauge(followerName);
    }

    private void addPeerCommitIndexGauge(RaftPeerId peerId) {
        this.getRegistry().gauge(RaftServerMetricsImpl.getPeerCommitIndexGaugeKey(peerId), () -> () -> Optional.ofNullable(this.commitInfoCache.get()).map(cache -> (RaftProtos.CommitInfoProto)cache.apply(peerId)).map(RaftProtos.CommitInfoProto::getCommitIndex).orElse(0L));
    }

    @VisibleForTesting
    static RaftServerMetricsImpl getImpl(RaftGroupMemberId serverId) {
        return METRICS.get(serverId);
    }

    public void recordFollowerHeartbeatElapsedTime(RaftPeerId followerId, long elapsedTimeNs) {
        this.followerLastHeartbeatElapsedTimeMap.put(followerId, elapsedTimeNs);
    }

    public Timekeeper getFollowerAppendEntryTimer(boolean isHeartbeat) {
        return this.followerAppendEntryLatency.apply(isHeartbeat);
    }

    public Timekeeper getClientRequestTimer(RaftClientRequest.Type request) {
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
            return this.readTimer;
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            return this.staleReadTimer;
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            return this.watchTimers.get(request.getWatch().getReplication());
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE)) {
            return this.writeTimer;
        }
        return null;
    }

    public void onRequestQueueLimitHit() {
        this.numRequestQueueLimitHits.inc();
    }

    public void addNumPendingRequestsGauge(Supplier<Integer> queueSize) {
        this.getRegistry().gauge(REQUEST_QUEUE_SIZE, () -> queueSize);
    }

    public boolean removeNumPendingRequestsGauge() {
        return this.getRegistry().remove(REQUEST_QUEUE_SIZE);
    }

    public void addNumPendingRequestsMegaByteSize(Supplier<Integer> megabyteSize) {
        this.getRegistry().gauge(REQUEST_MEGA_BYTE_SIZE, () -> megabyteSize);
    }

    public boolean removeNumPendingRequestsByteSize() {
        return this.getRegistry().remove(REQUEST_MEGA_BYTE_SIZE);
    }

    public void onRequestByteSizeLimitHit() {
        this.numRequestsByteSizeLimitHits.inc();
    }

    public void onResourceLimitHit() {
        this.numResourceLimitHits.inc();
    }

    void onFailedClientStaleRead() {
        this.numFailedClientStaleRead.inc();
    }

    void onFailedClientRead() {
        this.numFailedClientRead.inc();
    }

    void onFailedClientWatch() {
        this.numFailedClientWatch.inc();
    }

    void onFailedClientWrite() {
        this.numFailedClientWrite.inc();
    }

    void onFailedClientStream() {
        this.numFailedClientStream.inc();
    }

    public void incFailedRequestCount(RaftClientRequest.Type type) {
        if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            this.onFailedClientStaleRead();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            this.onFailedClientWatch();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE)) {
            this.onFailedClientWrite();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
            this.onFailedClientRead();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM)) {
            this.onFailedClientStream();
        }
    }

    @Override
    public void onSnapshotInstalled() {
        this.numInstallSnapshot.inc();
    }

    private static /* synthetic */ Double lambda$null$11(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).missRate();
    }

    private static /* synthetic */ Long lambda$null$9(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).missCount();
    }

    private static /* synthetic */ Double lambda$null$7(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).hitRate();
    }

    private static /* synthetic */ Long lambda$null$5(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).hitCount();
    }

    private static /* synthetic */ Long lambda$null$3(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).size();
    }
}

