/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.com.google.protobuf.Parser;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.thirdparty.io.grpc.Detachable;
import org.apache.ratis.thirdparty.io.grpc.HasByteBuffer;
import org.apache.ratis.thirdparty.io.grpc.KnownLength;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.protobuf.lite.ProtoLiteUtils;

public class ZeroCopyMessageMarshaller<T extends MessageLite>
implements MethodDescriptor.PrototypeMarshaller<T> {
    private Map<T, InputStream> unclosedStreams = Collections.synchronizedMap(new IdentityHashMap());
    private final Parser<T> parser;
    private final MethodDescriptor.PrototypeMarshaller<T> marshaller;

    public ZeroCopyMessageMarshaller(T defaultInstance) {
        this.parser = defaultInstance.getParserForType();
        this.marshaller = (MethodDescriptor.PrototypeMarshaller)ProtoLiteUtils.marshaller(defaultInstance);
    }

    @Override
    public Class<T> getMessageClass() {
        return this.marshaller.getMessageClass();
    }

    @Override
    public T getMessagePrototype() {
        return (T)((MessageLite)this.marshaller.getMessagePrototype());
    }

    @Override
    public InputStream stream(T value) {
        return this.marshaller.stream(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T parse(InputStream stream) {
        try {
            if (!(stream instanceof KnownLength)) return (T)((MessageLite)this.marshaller.parse(stream));
            if (!(stream instanceof Detachable)) return (T)((MessageLite)this.marshaller.parse(stream));
            if (!(stream instanceof HasByteBuffer)) return (T)((MessageLite)this.marshaller.parse(stream));
            if (!((HasByteBuffer)((Object)stream)).byteBufferSupported()) return (T)((MessageLite)this.marshaller.parse(stream));
            int size = stream.available();
            try (InputStream detachedStream = ((Detachable)((Object)stream)).detach();){
                T message;
                detachedStream.mark(size);
                LinkedList<ByteString> byteStrings = new LinkedList<ByteString>();
                while (detachedStream.available() != 0) {
                    ByteBuffer buffer = ((HasByteBuffer)((Object)detachedStream)).getByteBuffer();
                    byteStrings.add(UnsafeByteOperations.unsafeWrap(buffer));
                    detachedStream.skip(buffer.remaining());
                }
                detachedStream.reset();
                CodedInputStream codedInputStream = ByteString.copyFrom(byteStrings).newCodedInput();
                codedInputStream.enableAliasing(true);
                codedInputStream.setSizeLimit(Integer.MAX_VALUE);
                try {
                    message = this.parseFrom(codedInputStream);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
                this.unclosedStreams.put(message, detachedStream);
                detachedStream = null;
                T t2 = message;
                return t2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
        MessageLite message = (MessageLite)this.parser.parseFrom(stream);
        try {
            stream.checkLastTagWas(0);
            return (T)message;
        }
        catch (InvalidProtocolBufferException e) {
            e.setUnfinishedMessage(message);
            throw e;
        }
    }

    public InputStream popStream(T message) {
        return this.unclosedStreams.remove(message);
    }
}

