/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.client.AsyncRpcApi;
import org.apache.ratis.client.DataStreamClient;
import org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ratis.client.DataStreamOutputRpc;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.OrderedStreamAsync;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.io.StandardWriteOption;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SlidingWindow;

public class DataStreamClientImpl
implements DataStreamClient {
    private final RaftClient client;
    private final ClientId clientId;
    private final RaftGroupId groupId;
    private final RaftPeer dataStreamServer;
    private final DataStreamClientRpc dataStreamClientRpc;
    private final OrderedStreamAsync orderedStreamAsync;

    DataStreamClientImpl(ClientId clientId, RaftGroupId groupId, RaftPeer dataStreamServer, DataStreamClientRpc dataStreamClientRpc, RaftProperties properties) {
        this.client = null;
        this.clientId = clientId;
        this.groupId = groupId;
        this.dataStreamServer = dataStreamServer;
        this.dataStreamClientRpc = dataStreamClientRpc;
        this.orderedStreamAsync = new OrderedStreamAsync(dataStreamClientRpc, properties);
    }

    DataStreamClientImpl(RaftClient client, RaftPeer dataStreamServer, DataStreamClientRpc dataStreamClientRpc, RaftProperties properties) {
        this.client = client;
        this.clientId = client.getId();
        this.groupId = client.getGroupId();
        this.dataStreamServer = dataStreamServer;
        this.dataStreamClientRpc = dataStreamClientRpc;
        this.orderedStreamAsync = new OrderedStreamAsync(dataStreamClientRpc, properties);
    }

    @Override
    public DataStreamClientRpc getClientRpc() {
        return this.dataStreamClientRpc;
    }

    @Override
    public DataStreamOutputRpc stream(RaftClientRequest request) {
        return new DataStreamOutputImpl(request);
    }

    @Override
    public DataStreamOutputRpc stream(ByteBuffer headerMessage) {
        return this.stream(headerMessage, null);
    }

    @Override
    public DataStreamOutputRpc stream(ByteBuffer headerMessage, RoutingTable routingTable) {
        if (routingTable != null) {
            Preconditions.assertTrue(this.dataStreamServer.getId().equals(routingTable.getPrimary()), () -> "Primary peer mismatched: the routing table has " + routingTable.getPrimary() + " but the client has " + this.dataStreamServer.getId());
        }
        Message message = Optional.ofNullable(headerMessage).map(ByteString::copyFrom).map(Message::valueOf).orElse(null);
        RaftClientRequest request = RaftClientRequest.newBuilder().setClientId(this.clientId).setServerId(this.dataStreamServer.getId()).setGroupId(this.groupId).setCallId(CallId.getAndIncrement()).setMessage(message).setType(RaftClientRequest.dataStreamRequestType()).setRoutingTable(routingTable).build();
        return new DataStreamOutputImpl(request);
    }

    @Override
    public void close() throws IOException {
        this.dataStreamClientRpc.close();
    }

    public final class DataStreamOutputImpl
    implements DataStreamOutputRpc {
        private final RaftClientRequest header;
        private final CompletableFuture<DataStreamReply> headerFuture;
        private final SlidingWindow.Client<OrderedStreamAsync.DataStreamWindowRequest, DataStreamReply> slidingWindow;
        private final CompletableFuture<RaftClientReply> raftClientReplyFuture = new CompletableFuture();
        private CompletableFuture<DataStreamReply> closeFuture;
        private final MemoizedSupplier<WritableByteChannel> writableByteChannelSupplier = JavaUtils.memoize(() -> new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                int remaining = src.remaining();
                DataStreamReply reply = IOUtils.getFromFuture(DataStreamOutputImpl.this.writeAsync(src, new WriteOption[0]), () -> "write(" + remaining + " bytes for " + ClientInvocationId.valueOf(DataStreamOutputImpl.this.header) + ")");
                return Math.toIntExact(reply.getBytesWritten());
            }

            @Override
            public boolean isOpen() {
                return !DataStreamOutputImpl.this.isClosed();
            }

            @Override
            public void close() throws IOException {
                if (DataStreamOutputImpl.this.isClosed()) {
                    return;
                }
                IOUtils.getFromFuture(DataStreamOutputImpl.this.writeAsync(DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER, StandardWriteOption.CLOSE), () -> "close(" + ClientInvocationId.valueOf(DataStreamOutputImpl.this.header) + ")");
            }
        });
        private long streamOffset = 0L;

        private DataStreamOutputImpl(RaftClientRequest request) {
            this.header = request;
            this.slidingWindow = new SlidingWindow.Client(ClientInvocationId.valueOf(DataStreamClientImpl.this.clientId, this.header.getCallId()));
            ByteBuffer buffer = ClientProtoUtils.toRaftClientRequestProtoByteBuffer(this.header);
            this.headerFuture = this.send(RaftProtos.DataStreamPacketHeaderProto.Type.STREAM_HEADER, buffer, buffer.remaining(), Collections.emptyList());
        }

        private CompletableFuture<DataStreamReply> send(RaftProtos.DataStreamPacketHeaderProto.Type type, Object data, long length, Iterable<WriteOption> options) {
            DataStreamRequestHeader h2 = new DataStreamRequestHeader(this.header.getClientId(), type, this.header.getCallId(), this.streamOffset, length, options);
            return DataStreamClientImpl.this.orderedStreamAsync.sendRequest(h2, data, this.slidingWindow);
        }

        private CompletableFuture<DataStreamReply> combineHeader(CompletableFuture<DataStreamReply> future) {
            return future.thenCombine(this.headerFuture, (reply, headerReply) -> headerReply.isSuccess() ? reply : headerReply);
        }

        private CompletableFuture<DataStreamReply> writeAsyncImpl(Object data, long length, Iterable<WriteOption> options) {
            if (this.isClosed()) {
                return JavaUtils.completeExceptionally(new AlreadyClosedException(DataStreamClientImpl.this.clientId + ": stream already closed, request=" + this.header));
            }
            CompletableFuture<DataStreamReply> f = this.combineHeader(this.send(RaftProtos.DataStreamPacketHeaderProto.Type.STREAM_DATA, data, length, options));
            if (WriteOption.containsOption(options, (WriteOption)StandardWriteOption.CLOSE)) {
                this.closeFuture = DataStreamClientImpl.this.client != null ? f.thenCompose(this::sendForward) : f;
                ((CompletableFuture)this.closeFuture.thenApply(ClientProtoUtils::getRaftClientReply)).whenComplete(JavaUtils.asBiConsumer(this.raftClientReplyFuture));
            }
            this.streamOffset += length;
            return f;
        }

        @Override
        public CompletableFuture<DataStreamReply> writeAsync(ByteBuffer src, Iterable<WriteOption> options) {
            return this.writeAsyncImpl(src, src.remaining(), options);
        }

        @Override
        public CompletableFuture<DataStreamReply> writeAsync(FilePositionCount src, WriteOption ... options) {
            return this.writeAsyncImpl(src, src.getCount(), Arrays.asList(options));
        }

        boolean isClosed() {
            return this.closeFuture != null;
        }

        @Override
        public CompletableFuture<DataStreamReply> closeAsync() {
            if (!this.isClosed()) {
                this.writeAsync(DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER, StandardWriteOption.CLOSE);
            }
            return Objects.requireNonNull(this.closeFuture, "closeFuture == null");
        }

        public RaftClientRequest getHeader() {
            return this.header;
        }

        @Override
        public CompletableFuture<DataStreamReply> getHeaderFuture() {
            return this.headerFuture;
        }

        @Override
        public CompletableFuture<RaftClientReply> getRaftClientReplyFuture() {
            return this.raftClientReplyFuture;
        }

        @Override
        public WritableByteChannel getWritableByteChannel() {
            return this.writableByteChannelSupplier.get();
        }

        private CompletableFuture<DataStreamReply> sendForward(DataStreamReply writeReply) {
            DataStreamClient.LOG.debug("sendForward {}", (Object)writeReply);
            if (!writeReply.isSuccess()) {
                return CompletableFuture.completedFuture(writeReply);
            }
            AsyncRpcApi asyncRpc = (AsyncRpcApi)DataStreamClientImpl.this.client.async();
            return asyncRpc.sendForward(this.header).thenApply(clientReply -> DataStreamReplyByteBuffer.newBuilder().setClientId(DataStreamClientImpl.this.clientId).setType(writeReply.getType()).setStreamId(writeReply.getStreamId()).setStreamOffset(writeReply.getStreamOffset()).setBuffer(ClientProtoUtils.toRaftClientReplyProto(clientReply).toByteString().asReadOnlyByteBuffer()).setSuccess(clientReply.isSuccess()).setBytesWritten(writeReply.getBytesWritten()).setCommitInfos(clientReply.getCommitInfos()).build());
        }
    }
}

