/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.io.grpc.KnownLength;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZeroCopyReadinessChecker {
    static final Logger LOG = LoggerFactory.getLogger(ZeroCopyReadinessChecker.class);
    private static final boolean IS_ZERO_COPY_READY;

    private ZeroCopyReadinessChecker() {
    }

    public static boolean isReady() {
        return IS_ZERO_COPY_READY;
    }

    static {
        boolean detachableClassExists = false;
        try {
            String knownLengthClassName = KnownLength.class.getName();
            String detachableClassName = knownLengthClassName.substring(0, knownLengthClassName.lastIndexOf(46) + 1) + "Detachable";
            Class.forName(detachableClassName);
            detachableClassExists = true;
        }
        catch (ClassNotFoundException ex) {
            LOG.debug("io.grpc.Detachable not found", (Throwable)ex);
        }
        boolean unsafeByteOperationsClassExists = false;
        try {
            String messageLiteClassName = MessageLite.class.getName();
            String unsafeByteOperationsClassName = messageLiteClassName.substring(0, messageLiteClassName.lastIndexOf(46) + 1) + "UnsafeByteOperations";
            Class.forName(unsafeByteOperationsClassName);
            unsafeByteOperationsClassExists = true;
        }
        catch (ClassNotFoundException ex) {
            LOG.debug("com.google.protobuf.UnsafeByteOperations not found", (Throwable)ex);
        }
        IS_ZERO_COPY_READY = detachableClassExists && unsafeByteOperationsClassExists;
    }
}

