/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.Closeable;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.util.StreamObserverWithTimeout;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NegotiationType;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.CallStreamObserver;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServerProtocolClient
implements Closeable {
    private final ManagedChannel channel;
    private ManagedChannel hbChannel;
    private RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub hbAsyncStub;
    private final RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub asyncStub;
    private final RaftServerProtocolServiceGrpc.RaftServerProtocolServiceBlockingStub blockingStub;
    private final boolean useSeparateHBChannel;
    private final TimeDuration requestTimeoutDuration;
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServerProtocolClient.class);
    private final RaftPeerId raftPeerId;

    public GrpcServerProtocolClient(RaftPeer target, int flowControlWindow, TimeDuration requestTimeout, GrpcTlsConfig tlsConfig, boolean separateHBChannel) {
        this.raftPeerId = target.getId();
        LOG.info("Build channel for {}", (Object)this.raftPeerId);
        this.useSeparateHBChannel = separateHBChannel;
        this.channel = this.buildChannel(target, flowControlWindow, tlsConfig);
        this.blockingStub = RaftServerProtocolServiceGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = RaftServerProtocolServiceGrpc.newStub((Channel)this.channel);
        if (this.useSeparateHBChannel) {
            this.hbChannel = this.buildChannel(target, flowControlWindow, tlsConfig);
            this.hbAsyncStub = RaftServerProtocolServiceGrpc.newStub((Channel)this.hbChannel);
        }
        this.requestTimeoutDuration = requestTimeout;
    }

    private ManagedChannel buildChannel(RaftPeer target, int flowControlWindow, GrpcTlsConfig tlsConfig) {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)target.getAddress());
        if (tlsConfig != null) {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            GrpcUtil.setTrustManager(sslContextBuilder, tlsConfig.getTrustManager());
            if (tlsConfig.getMtlsEnabled()) {
                GrpcUtil.setKeyManager(sslContextBuilder, tlsConfig.getKeyManager());
            }
            try {
                channelBuilder.useTransportSecurity().sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to build SslContext, peerId=" + this.raftPeerId + ", tlsConfig=" + (Object)((Object)tlsConfig), ex);
            }
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        channelBuilder.disableRetry();
        return channelBuilder.flowControlWindow(flowControlWindow).build();
    }

    @Override
    public void close() {
        LOG.info("{} Close channels", (Object)this.raftPeerId);
        if (this.useSeparateHBChannel) {
            GrpcUtil.shutdownManagedChannel(this.hbChannel);
        }
        GrpcUtil.shutdownManagedChannel(this.channel);
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) {
        RaftProtos.RequestVoteReplyProto r = ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).requestVote(request);
        return r;
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) {
        RaftProtos.StartLeaderElectionReplyProto r = ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).startLeaderElection(request);
        return r;
    }

    void readIndex(RaftProtos.ReadIndexRequestProto request, StreamObserver<RaftProtos.ReadIndexReplyProto> s) {
        ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub)this.asyncStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).readIndex(request, s);
    }

    CallStreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(StreamObserver<RaftProtos.AppendEntriesReplyProto> responseHandler, boolean isHeartbeat) {
        if (isHeartbeat && this.useSeparateHBChannel) {
            return (CallStreamObserver)this.hbAsyncStub.appendEntries(responseHandler);
        }
        return (CallStreamObserver)this.asyncStub.appendEntries(responseHandler);
    }

    StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(String name, TimeDuration timeout, int limit, StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseHandler) {
        return StreamObserverWithTimeout.newInstance(name, ServerStringUtils::toInstallSnapshotRequestString, timeout, limit, i -> ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub)this.asyncStub.withInterceptors(new ClientInterceptor[]{i})).installSnapshot(responseHandler));
    }

    public void resetConnectBackoff() {
        if (this.useSeparateHBChannel) {
            this.hbChannel.resetConnectBackoff();
        }
        this.channel.resetConnectBackoff();
    }
}

