/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.ratis.thirdparty.com.google.common.cache.Cache;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteStringUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

public abstract class RaftId {
    static final UUID ZERO_UUID = new UUID(0L, 0L);
    static final ByteString ZERO_UUID_BYTESTRING = RaftId.toByteString(ZERO_UUID);
    private static final int BYTE_LENGTH = 16;
    private final UUID uuid;
    private final Supplier<ByteString> uuidBytes;
    private final Supplier<String> uuidString;

    static UUID toUuid(ByteString bytes) {
        Objects.requireNonNull(bytes, "bytes == null");
        Preconditions.assertSame(16L, bytes.size(), "bytes.size()");
        ByteBuffer buf = bytes.asReadOnlyByteBuffer();
        return new UUID(buf.getLong(), buf.getLong());
    }

    static ByteString toByteString(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid == null");
        byte[] array = new byte[16];
        ByteBuffer.wrap(array).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return ByteStringUtils.unsafeWrap(array);
    }

    private RaftId(UUID uuid, Supplier<ByteString> uuidBytes) {
        this.uuid = Preconditions.assertNotNull(uuid, "uuid");
        this.uuidBytes = uuidBytes;
        this.uuidString = JavaUtils.memoize(() -> this.createUuidString(uuid));
    }

    RaftId(UUID uuid) {
        this(uuid, JavaUtils.memoize(() -> RaftId.toByteString(uuid)));
        Preconditions.assertTrue(!uuid.equals(ZERO_UUID), () -> "Failed to create " + JavaUtils.getClassSimpleName(this.getClass()) + ": UUID " + ZERO_UUID + " is reserved.");
    }

    RaftId(UUID uuid, ByteString bytes) {
        this(uuid, () -> bytes);
        Preconditions.assertTrue(RaftId.toUuid(bytes).equals(uuid));
    }

    String createUuidString(UUID id) {
        String s = id.toString().toUpperCase();
        int i = s.lastIndexOf(45);
        return s.substring(i + 1);
    }

    public ByteString toByteString() {
        return this.uuidBytes.get();
    }

    public String toString() {
        return this.uuidString.get();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RaftId && this.getClass() == other.getClass() && this.uuid.equals(((RaftId)other).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    static abstract class Factory<ID extends RaftId> {
        private final Cache<UUID, ID> cache = CacheBuilder.newBuilder().weakValues().build();

        Factory() {
        }

        abstract ID newInstance(UUID var1, ByteString var2);

        private ID valueOf(UUID uuid, ByteString bytes) {
            try {
                return (ID)((RaftId)this.cache.get((Object)uuid, () -> this.newInstance(uuid, bytes)));
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Failed to valueOf(" + uuid + ")", e);
            }
        }

        final ID valueOf(UUID uuid) {
            return this.valueOf(uuid, null);
        }

        final ID valueOf(ByteString bytes) {
            return bytes != null ? this.valueOf(RaftId.toUuid(bytes), bytes) : this.emptyId();
        }

        ID emptyId() {
            return this.valueOf(ZERO_UUID, ZERO_UUID_BYTESTRING);
        }

        ID randomId() {
            return this.valueOf(UUID.randomUUID(), null);
        }
    }
}

