/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.logservice.api.LogInfo;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.proto.MetaServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public final class MetaServiceProtoUtil {
    private MetaServiceProtoUtil() {
    }

    public static MetaServiceProtos.RaftPeerProto toRaftPeerProto(RaftPeer peer) {
        MetaServiceProtos.RaftPeerProto.Builder builder = MetaServiceProtos.RaftPeerProto.newBuilder().setId(peer.getId().toByteString());
        if (peer.getAddress() != null) {
            builder.setAddress(peer.getAddress());
        }
        return builder.build();
    }

    public static RaftPeer toRaftPeer(MetaServiceProtos.RaftPeerProto p) {
        return RaftPeer.newBuilder().setId(p.getId()).setAddress(p.getAddress()).build();
    }

    public static RaftGroup toRaftGroup(MetaServiceProtos.RaftGroupProto proto) {
        return RaftGroup.valueOf((RaftGroupId)RaftGroupId.valueOf((ByteString)proto.getId()), (RaftPeer[])MetaServiceProtoUtil.toRaftPeerArray(proto.getPeersList()));
    }

    public static MetaServiceProtos.RaftGroupProto toRaftGroupProto(RaftGroup group) {
        return MetaServiceProtos.RaftGroupProto.newBuilder().setId(group.getGroupId().toByteString()).addAllPeers(MetaServiceProtoUtil.toRaftPeerProtos(group.getPeers())).build();
    }

    public static LogInfo toLogInfo(MetaServiceProtos.LogInfoProto logProto) {
        return new LogInfo(LogServiceProtoUtil.toLogName(logProto.getLogname()), MetaServiceProtoUtil.toRaftGroup(logProto.getRaftGroup()));
    }

    public static MetaServiceProtos.LogInfoProto toLogInfoProto(LogInfo logInfo) {
        return MetaServiceProtos.LogInfoProto.newBuilder().setLogname(LogServiceProtoUtil.toLogNameProto(logInfo.getLogName())).setRaftGroup(MetaServiceProtoUtil.toRaftGroupProto(logInfo.getRaftGroup())).build();
    }

    public static MetaServiceProtos.MetaSMRequestProto toPingRequestProto(RaftPeer peer) {
        return MetaServiceProtos.MetaSMRequestProto.newBuilder().setPingRequest(MetaServiceProtos.LogServicePingRequestProto.newBuilder().setPeer(MetaServiceProtoUtil.toRaftPeerProto(peer)).build()).build();
    }

    public static MetaServiceProtos.MetaSMRequestProto toHeartbeatRequestProto(RaftPeer peer) {
        return MetaServiceProtos.MetaSMRequestProto.newBuilder().setHeartbeatRequest(MetaServiceProtos.LogServiceHeartbeatRequestProto.newBuilder().setPeer(MetaServiceProtoUtil.toRaftPeerProto(peer)).build()).build();
    }

    public static MetaServiceProtos.MetaServiceRequestProto toCreateLogRequestProto(LogName logName) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(logName.getName()).build();
        MetaServiceProtos.CreateLogRequestProto createLog = MetaServiceProtos.CreateLogRequestProto.newBuilder().setLogName(logNameProto).build();
        return MetaServiceProtos.MetaServiceRequestProto.newBuilder().setCreateLog(createLog).build();
    }

    public static MetaServiceProtos.MetaServiceRequestProto toListLogRequestProto() {
        MetaServiceProtos.ListLogsRequestProto listLogs = MetaServiceProtos.ListLogsRequestProto.newBuilder().build();
        return MetaServiceProtos.MetaServiceRequestProto.newBuilder().setListLogs(listLogs).build();
    }

    public static MetaServiceProtos.MetaServiceRequestProto toGetLogRequestProto(LogName name) {
        MetaServiceProtos.GetLogRequestProto getLog = MetaServiceProtos.GetLogRequestProto.newBuilder().setLogName(LogServiceProtoUtil.toLogNameProto(name)).build();
        return MetaServiceProtos.MetaServiceRequestProto.newBuilder().setGetLog(getLog).build();
    }

    public static MetaServiceProtos.MetaServiceRequestProto toDeleteLogRequestProto(LogName logName) {
        LogServiceProtos.LogNameProto logNameProto = LogServiceProtos.LogNameProto.newBuilder().setName(logName.getName()).build();
        MetaServiceProtos.DeleteLogRequestProto deleteLog = MetaServiceProtos.DeleteLogRequestProto.newBuilder().setLogName(logNameProto).build();
        return MetaServiceProtos.MetaServiceRequestProto.newBuilder().setDeleteLog(deleteLog).build();
    }

    public static MetaServiceProtos.CreateLogReplyProto.Builder toCreateLogReplyProto(LogInfo logInfo) {
        return MetaServiceProtos.CreateLogReplyProto.newBuilder().setLog(MetaServiceProtoUtil.toLogInfoProto(logInfo));
    }

    public static MetaServiceProtos.ListLogsReplyProto toListLogLogsReplyProto(List<LogInfo> logInfos) {
        return MetaServiceProtos.ListLogsReplyProto.newBuilder().addAllLogs(logInfos.stream().map(log -> MetaServiceProtoUtil.toLogInfoProto(log)).collect(Collectors.toList())).build();
    }

    public static MetaServiceProtos.GetLogReplyProto toGetLogReplyProto(LogInfo logInfo) {
        return MetaServiceProtos.GetLogReplyProto.newBuilder().setLog(MetaServiceProtoUtil.toLogInfoProto(logInfo)).build();
    }

    public static MetaServiceProtos.MetaServiceExceptionProto toMetaServiceExceptionProto(Exception exception) {
        Throwable t = exception.getCause() != null ? exception.getCause() : exception;
        return MetaServiceProtos.MetaServiceExceptionProto.newBuilder().setExceptionClassName(t.getClass().getName()).setErrorMsg(t.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString((Object)t.getStackTrace())).build();
    }

    public static MetaServiceProtos.CreateLogReplyProto.Builder toCreateLogExceptionReplyProto(Exception e) {
        return MetaServiceProtos.CreateLogReplyProto.newBuilder().setException(MetaServiceProtoUtil.toMetaServiceExceptionProto(e));
    }

    public static MetaServiceProtos.GetLogReplyProto.Builder toGetLogExceptionReplyProto(Exception e) {
        return MetaServiceProtos.GetLogReplyProto.newBuilder().setException(MetaServiceProtoUtil.toMetaServiceExceptionProto(e));
    }

    public static MetaServiceProtos.DeleteLogReplyProto.Builder toDeleteLogExceptionReplyProto(Exception e) {
        return MetaServiceProtos.DeleteLogReplyProto.newBuilder().setException(MetaServiceProtoUtil.toMetaServiceExceptionProto(e));
    }

    public static IOException toMetaServiceException(MetaServiceProtos.MetaServiceExceptionProto exceptionProto) {
        try {
            Class<?> clazz = Class.forName(exceptionProto.getExceptionClassName());
            Exception e = (Exception)ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), (String)exceptionProto.getErrorMsg());
            IOException result = e instanceof IOException ? (IOException)e : new IOException(e);
            StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject((ByteString)exceptionProto.getStacktrace());
            result.setStackTrace(stacktrace);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static RaftPeer[] toRaftPeerArray(List<MetaServiceProtos.RaftPeerProto> protos) {
        RaftPeer[] peers = new RaftPeer[protos.size()];
        for (int i = 0; i < peers.length; ++i) {
            peers[i] = MetaServiceProtoUtil.toRaftPeer(protos.get(i));
        }
        return peers;
    }

    static Iterable<MetaServiceProtos.RaftPeerProto> toRaftPeerProtos(final Collection<RaftPeer> peers) {
        return () -> new Iterator<MetaServiceProtos.RaftPeerProto>(){
            private final Iterator i;
            {
                this.i = peers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public MetaServiceProtos.RaftPeerProto next() {
                return MetaServiceProtoUtil.toRaftPeerProto((RaftPeer)this.i.next());
            }
        };
    }

    public static MetaServiceProtos.DeleteLogReplyProto toDeleteLogReplyProto() {
        return MetaServiceProtos.DeleteLogReplyProto.newBuilder().build();
    }
}

