/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.shell.commands;

import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogServiceClient;
import org.apache.ratis.logservice.shell.Command;
import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;

public class ArchiveLogCommand
implements Command {
    @Override
    public String getHelpMessage() {
        return "`archive` - archive the given log at already configured location";
    }

    @Override
    public void run(Terminal terminal, LineReader lineReader, LogServiceClient client, String[] args) {
        if (args.length != 1) {
            terminal.writer().println("ERROR - Usage: archive <name> ");
            return;
        }
        String logName = args[0];
        try {
            client.archiveLog(LogName.of(logName));
            terminal.writer().println("Archive Log request is submitted successfully!!");
        }
        catch (Exception e) {
            terminal.writer().println("Failed to archive log!!");
            e.printStackTrace(terminal.writer());
        }
    }
}

