/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.api;

import java.net.URL;
import java.util.UUID;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.common.Constants;
import org.apache.ratis.logservice.server.MetadataServer;
import org.apache.ratis.logservice.server.ServerOpts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogServiceConfiguration
extends RaftProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataServer.class);
    public static final String RESOURCE_NAME = "logservice.xml";

    public static LogServiceConfiguration create() {
        return new LogServiceConfiguration();
    }

    public static LogServiceConfiguration create(String resourceName) {
        return new LogServiceConfiguration(resourceName);
    }

    public static LogServiceConfiguration create(URL resourcePath) {
        return new LogServiceConfiguration(resourcePath);
    }

    private LogServiceConfiguration() {
        this.addResource(RESOURCE_NAME);
    }

    private LogServiceConfiguration(String resourceName) {
        this.addResource(resourceName);
    }

    private LogServiceConfiguration(URL resourcePath) {
        this.addResource(resourcePath);
    }

    public ServerOpts addLogServerOpts(ServerOpts opts) {
        String val;
        if (!opts.isHostSet() && (val = this.get("logservice.logserver.hostname", "localhost")) != null) {
            opts.setHost(val);
        }
        if (!opts.isPortSet() && (val = this.get("logservice.logserver.port")) != null) {
            try {
                opts.setPort(Integer.parseInt(val));
            }
            catch (Exception e) {
                LOG.warn("Config value {} for {} is invaild", (Object)val, (Object)"logservice.logserver.port");
            }
        }
        if (!opts.isWorkingDirSet() && (val = this.get("logservice.logserver.workdir")) != null) {
            opts.setWorkingDir(val);
        }
        if (!opts.isMetaQuorumSet() && (val = this.get("logservice.metaquorum")) != null) {
            opts.setMetaQuorum(val);
        }
        if (!opts.isLogServerGroupIdSet()) {
            val = this.get("logservice.logserver.groupid");
            if (val != null) {
                try {
                    opts.setLogServerGroupId(UUID.fromString(val));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Config value {} for {} is invaild", (Object)val, (Object)"logservice.logserver.groupid");
                }
            } else {
                opts.setLogServerGroupId(Constants.SERVERS_GROUP_UUID);
            }
        }
        return opts;
    }

    public ServerOpts addMetaServerOpts(ServerOpts opts) {
        String val;
        if (!opts.isHostSet() && (val = this.get("logservice.metaserver.hostname")) != null) {
            opts.setHost(val);
        }
        if (!opts.isPortSet() && (val = this.get("logservice.metaserver.port")) != null) {
            try {
                opts.setPort(Integer.parseInt(val));
            }
            catch (Exception e) {
                LOG.warn("Config value {} for {} is invaild", (Object)val, (Object)"logservice.metaserver.port");
            }
        }
        if (!opts.isWorkingDirSet() && (val = this.get("logservice.metaserver.workdir")) != null) {
            opts.setWorkingDir(val);
        }
        if (!opts.isMetaQuorumSet() && (val = this.get("logservice.metaquorum")) != null) {
            opts.setMetaQuorum(val);
        }
        if (!opts.isMetaServerGroupIdSet()) {
            val = this.get("logservice.metaserver.groupid");
            if (val != null) {
                try {
                    opts.setMetaGroupId(UUID.fromString(val));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Config value {} for {} is invaild", (Object)val, (Object)"logservice.metaserver.groupid");
                }
            } else {
                opts.setMetaGroupId(Constants.META_GROUP_UUID);
            }
        }
        return opts;
    }
}

