/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.protocol.RaftPeer;

public final class LogServiceUtils {
    private LogServiceUtils() {
    }

    public static Set<RaftPeer> getPeersFromIds(String identity) {
        return Stream.of(identity.split(",")).map(elem -> RaftPeer.newBuilder().setId(elem).setAddress(elem.replace('_', ':')).build()).collect(Collectors.toSet());
    }

    public static Set<RaftPeer> getPeersFromQuorum(String identity) {
        return Stream.of(identity.split(",")).map(elem -> RaftPeer.newBuilder().setId(elem.replace(':', '_')).setAddress(elem).build()).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHostName() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String string = socket.getLocalAddress().getHostName();
            return string;
        }
        catch (IOException e) {
            return "localhost";
        }
    }

    public static String getArchiveLocationForLog(String location, LogName logName) {
        return location + "/" + logName.getName();
    }

    public static String getRolledPathForArchiveWriter(Path path, long lastWrittenId) {
        return path + "_recordId_" + lastWrittenId;
    }

    public static Integer getRecordIdFromRolledArchiveFile(Path path) {
        String[] splits = path.getName().split("_recordId_");
        if (splits.length != 2) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(splits[1]);
    }
}

