/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import com.codahale.metrics.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.LogInfo;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.common.LogAlreadyExistException;
import org.apache.ratis.logservice.common.LogNotFoundException;
import org.apache.ratis.logservice.common.NoEnoughWorkersException;
import org.apache.ratis.logservice.metrics.LogServiceMetaDataMetrics;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.proto.MetaServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.logservice.util.MetaServiceProtoUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStateMachine
extends BaseStateMachine {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStateMachine.class);
    private Map<LogName, RaftGroup> map = new ConcurrentHashMap<LogName, RaftGroup>();
    private final Set<RaftPeer> peers = new HashSet<RaftPeer>();
    private RaftServer raftServer;
    private Map<RaftPeer, Set<LogName>> peerLogs = new ConcurrentHashMap<RaftPeer, Set<LogName>>();
    private Map<RaftPeer, Long> heartbeatInfo = new ConcurrentHashMap<RaftPeer, Long>();
    private RaftGroup currentGroup = null;
    private Daemon peerHealthChecker = null;
    private long failureDetectionPeriod = 60000L;
    private PriorityBlockingQueue<PeerGroups> avail = new PriorityBlockingQueue();
    private RaftProperties properties = new RaftProperties();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private RaftGroupId metadataGroupId;
    private RaftGroupId logServerGroupId;
    private LogServiceMetaDataMetrics logServiceMetaDataMetrics;

    public MetaStateMachine(RaftGroupId metadataGroupId, RaftGroupId logServerGroupId, long failureDetectionPeriod) {
        this.metadataGroupId = metadataGroupId;
        this.logServerGroupId = logServerGroupId;
        this.failureDetectionPeriod = failureDetectionPeriod;
    }

    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage storage) throws IOException {
        this.raftServer = server;
        this.logServiceMetaDataMetrics = new LogServiceMetaDataMetrics(server.getId().toString());
        super.initialize(server, groupId, storage);
        this.peerHealthChecker = new Daemon((Runnable)new PeerHealthChecker(), "peer-Health-Checker");
        this.peerHealthChecker.start();
    }

    @VisibleForTesting
    public void setProperties(RaftProperties properties) {
        this.properties = properties;
    }

    public TransactionContext applyTransactionSerial(TransactionContext trx) throws InvalidProtocolBufferException {
        RaftProtos.LogEntryProto x = trx.getLogEntry();
        MetaServiceProtos.MetaSMRequestProto req = null;
        try {
            req = MetaServiceProtos.MetaSMRequestProto.parseFrom(x.getStateMachineLogEntry().getLogData());
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            throw e;
        }
        switch (req.getTypeCase()) {
            case REGISTERREQUEST: {
                MetaServiceProtos.LogServiceRegisterLogRequestProto r = req.getRegisterRequest();
                LogName logname = LogServiceProtoUtil.toLogName(r.getLogname());
                RaftGroup rg = MetaServiceProtoUtil.toRaftGroup(r.getRaftGroup());
                rg.getPeers().stream().forEach(raftPeer -> {
                    Set<Object> logNames;
                    if (!this.peerLogs.containsKey(raftPeer)) {
                        logNames = new HashSet();
                        this.peerLogs.put((RaftPeer)raftPeer, (Set<LogName>)logNames);
                    } else {
                        logNames = this.peerLogs.get(raftPeer);
                    }
                    logNames.add(logname);
                });
                this.map.put(logname, rg);
                LOG.info("Log {} registered at {} with group {} ", new Object[]{logname, this.getId(), rg});
                break;
            }
            case UNREGISTERREQUEST: {
                MetaServiceProtos.LogServiceUnregisterLogRequestProto unregReq = req.getUnregisterRequest();
                LogName logname = LogServiceProtoUtil.toLogName(unregReq.getLogname());
                this.map.remove(logname);
                break;
            }
            case PINGREQUEST: {
                MetaServiceProtos.LogServicePingRequestProto pingRequest = req.getPingRequest();
                RaftPeer peer = MetaServiceProtoUtil.toRaftPeer(pingRequest.getPeer());
                if (this.peers.contains(peer)) break;
                this.peers.add(peer);
                this.avail.add(new PeerGroups(peer));
                this.heartbeatInfo.put(peer, System.currentTimeMillis());
                break;
            }
            case HEARTBEATREQUEST: {
                MetaServiceProtos.LogServiceHeartbeatRequestProto heartbeatRequest = req.getHeartbeatRequest();
                RaftPeer heartbeatPeer = MetaServiceProtoUtil.toRaftPeer(heartbeatRequest.getPeer());
                this.heartbeatInfo.put(heartbeatPeer, System.currentTimeMillis());
                break;
            }
        }
        return super.applyTransactionSerial(trx);
    }

    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        return super.startTransaction(request);
    }

    public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
        return super.preAppendTransaction(trx);
    }

    public CompletableFuture<Message> queryStale(Message request, long minIndex) {
        return super.queryStale(request, minIndex);
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        return super.applyTransaction(trx);
    }

    public CompletableFuture<Message> query(Message request) {
        MetaServiceProtos.MetaServiceRequestProto req;
        Timer.Context timerContext = null;
        MetaServiceProtos.MetaServiceRequestProto.TypeCase type = null;
        if (this.currentGroup == null) {
            try {
                List x = StreamSupport.stream(this.raftServer.getGroups().spliterator(), false).filter(group -> group.getGroupId().equals((Object)this.metadataGroupId)).collect(Collectors.toList());
                if (x.size() == 1) {
                    this.currentGroup = (RaftGroup)x.get(0);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            req = MetaServiceProtos.MetaServiceRequestProto.parseFrom(request.getContent());
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return null;
        }
        type = req.getTypeCase();
        try {
            CompletableFuture reply;
            timerContext = this.logServiceMetaDataMetrics.getTimer(type.name()).time();
            switch (type) {
                case CREATELOG: {
                    CompletableFuture<Message> e = this.processCreateLogRequest(req);
                    return e;
                }
                case LISTLOGS: {
                    CompletableFuture<Message> e = this.processListLogsRequest();
                    return e;
                }
                case GETLOG: {
                    CompletableFuture<Message> e = this.processGetLogRequest(req);
                    return e;
                }
                case DELETELOG: {
                    CompletableFuture<Message> e = this.processDeleteLog(req);
                    return e;
                }
            }
            CompletableFuture completableFuture = reply = super.query(request);
            return completableFuture;
        }
        catch (Exception e) {
            LOG.error("Exception during Meta State Machine query");
            throw e;
        }
        finally {
            if (timerContext != null) {
                timerContext.stop();
            }
        }
    }

    private CompletableFuture<Message> processDeleteLog(MetaServiceProtos.MetaServiceRequestProto logServiceRequestProto) {
        MetaServiceProtos.DeleteLogRequestProto deleteLog = logServiceRequestProto.getDeleteLog();
        LogName logName = LogServiceProtoUtil.toLogName(deleteLog.getLogName());
        RaftGroup raftGroup = this.map.get(logName);
        if (raftGroup == null) {
            return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toDeleteLogExceptionReplyProto(new LogNotFoundException(logName.getName())).build().toByteString()));
        }
        Collection raftPeers = raftGroup.getPeers();
        raftPeers.stream().forEach(peer -> {
            try (RaftClient client = RaftClient.newBuilder().setProperties(this.properties).setClientId(ClientId.randomId()).setRaftGroup(RaftGroup.valueOf((RaftGroupId)this.logServerGroupId, (RaftPeer[])new RaftPeer[]{peer})).build();){
                client.getGroupManagementApi(peer.getId()).remove(raftGroup.getGroupId(), true, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        try (RaftClient client = RaftClient.newBuilder().setRaftGroup(this.currentGroup).setClientId(ClientId.randomId()).setProperties(this.properties).build();){
            client.io().send(() -> MetaServiceProtos.MetaSMRequestProto.newBuilder().setUnregisterRequest(MetaServiceProtos.LogServiceUnregisterLogRequestProto.newBuilder().setLogname(LogServiceProtoUtil.toLogNameProto(logName))).build().toByteString());
        }
        catch (IOException e) {
            LOG.error("Exception while unregistring raft group with Metadata Service during deletion of log");
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toDeleteLogReplyProto().toByteString()));
    }

    private CompletableFuture<Message> processCreateLogRequest(MetaServiceProtos.MetaServiceRequestProto logServiceRequestProto) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            Object object;
            MetaServiceProtos.CreateLogRequestProto createLog = logServiceRequestProto.getCreateLog();
            LogName name = LogServiceProtoUtil.toLogName(createLog.getLogName());
            if (this.map.containsKey(name)) {
                CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogExceptionReplyProto(new LogAlreadyExistException(name.getName())).build().toByteString()));
                return completableFuture;
            }
            if (this.avail.size() < 3) {
                CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogExceptionReplyProto(new NoEnoughWorkersException(this.avail.size())).build().toByteString()));
                return completableFuture;
            }
            List peerGroup = IntStream.range(0, 3).mapToObj(i -> this.avail.poll()).collect(Collectors.toList());
            List peersFromGroup = peerGroup.stream().map(obj -> obj.getPeer()).collect(Collectors.toList());
            RaftGroup raftGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), peersFromGroup);
            peerGroup.stream().forEach(pg -> {
                pg.getGroups().add(raftGroup);
                this.avail.add((PeerGroups)pg);
            });
            int provisionedPeers = 0;
            IOException originalException = null;
            for (RaftPeer peer : this.peers) {
                try (RaftClient client = RaftClient.newBuilder().setProperties(this.properties).setRaftGroup(RaftGroup.valueOf((RaftGroupId)this.logServerGroupId, (RaftPeer[])new RaftPeer[]{peer})).build();){
                    client.getGroupManagementApi(peer.getId()).add(raftGroup);
                }
                catch (IOException e) {
                    LOG.error("Failed to add Raft group ({}) for new Log({})", new Object[]{raftGroup.getGroupId(), name, e});
                    originalException = e;
                    break;
                }
                ++provisionedPeers;
            }
            if (provisionedPeers != this.peers.size()) {
                int tornDownPeers = 0;
                for (RaftPeer peer : this.peers) {
                    if (tornDownPeers >= provisionedPeers) break;
                    try (RaftClient client = RaftClient.newBuilder().setProperties(this.properties).setRaftGroup(RaftGroup.valueOf((RaftGroupId)this.logServerGroupId, (RaftPeer[])new RaftPeer[]{peer})).build();){
                        client.getGroupManagementApi(peer.getId()).remove(raftGroup.getGroupId(), true, false);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to clean up Raft group ({}) for peer ({}), ignoring exception", new Object[]{raftGroup.getGroupId(), peer, e});
                    }
                    ++tornDownPeers;
                }
                object = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogExceptionReplyProto(originalException).build().toByteString()));
                return object;
            }
            try {
                RaftClient client = RaftClient.newBuilder().setRaftGroup(this.currentGroup).setClientId(ClientId.randomId()).setProperties(this.properties).build();
                object = null;
                try {
                    client.io().send(() -> MetaServiceProtos.MetaSMRequestProto.newBuilder().setRegisterRequest(MetaServiceProtos.LogServiceRegisterLogRequestProto.newBuilder().setLogname(LogServiceProtoUtil.toLogNameProto(name)).setRaftGroup(MetaServiceProtoUtil.toRaftGroupProto(raftGroup))).build().toByteString());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (client != null) {
                        if (object != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            client.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Exception while registering raft group with Metadata Service during creation of log");
                object = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogExceptionReplyProto(e).build().toByteString()));
                if (writeLock != null) {
                    if (var4_3 != null) {
                        try {
                            writeLock.close();
                        }
                        catch (Throwable throwable) {
                            var4_3.addSuppressed(throwable);
                        }
                    } else {
                        writeLock.close();
                    }
                }
                return object;
            }
            CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogReplyProto(new LogInfo(name, raftGroup)).build().toByteString()));
            return completableFuture;
        }
    }

    private AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.writeLock());
    }

    private CompletableFuture<Message> processListLogsRequest() {
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toListLogLogsReplyProto(this.map.entrySet().stream().map(log -> new LogInfo((LogName)log.getKey(), (RaftGroup)log.getValue())).collect(Collectors.toList())).toByteString()));
    }

    private CompletableFuture<Message> processGetLogRequest(MetaServiceProtos.MetaServiceRequestProto logServiceRequestProto) {
        MetaServiceProtos.GetLogRequestProto getLog = logServiceRequestProto.getGetLog();
        LogName logName = LogServiceProtoUtil.toLogName(getLog.getLogName());
        RaftGroup raftGroup = this.map.get(logName);
        if (raftGroup != null) {
            return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toGetLogReplyProto(new LogInfo(logName, raftGroup)).toByteString()));
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toGetLogExceptionReplyProto(new LogNotFoundException(logName.getName())).build().toByteString()));
    }

    public boolean checkPeersAreSame() {
        if (!this.peers.equals(this.peerLogs.keySet()) || !this.peers.equals(this.heartbeatInfo.keySet())) {
            return false;
        }
        HashSet availPeers = new HashSet();
        this.avail.stream().forEach(peerGroups -> availPeers.add(peerGroups.getPeer()));
        return this.peers.equals(availPeers);
    }

    public void close() {
        this.logServiceMetaDataMetrics.unregister();
    }

    private class PeerHealthChecker
    implements Runnable {
        private PeerHealthChecker() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        long now = System.currentTimeMillis();
                        MetaStateMachine.this.heartbeatInfo.keySet().stream().forEach(raftPeer -> {
                            Long heartbeatTimestamp = (Long)MetaStateMachine.this.heartbeatInfo.get(raftPeer);
                            if (now - heartbeatTimestamp > MetaStateMachine.this.failureDetectionPeriod) {
                                if (MetaStateMachine.this.peerLogs.containsKey(raftPeer)) {
                                    LOG.warn("Closing all logs hosted by peer {} because last heartbeat ({}ms) exceeds the threshold ({}ms)", new Object[]{raftPeer, now - heartbeatTimestamp, MetaStateMachine.this.failureDetectionPeriod});
                                    MetaStateMachine.this.peers.remove(raftPeer);
                                    Set logNames = (Set)MetaStateMachine.this.peerLogs.get(raftPeer);
                                    Iterator itr = logNames.iterator();
                                    while (itr.hasNext()) {
                                        LogName logName = (LogName)itr.next();
                                        RaftGroup group = (RaftGroup)MetaStateMachine.this.map.get(logName);
                                        try {
                                            RaftClient client = RaftClient.newBuilder().setRaftGroup(group).setProperties(MetaStateMachine.this.properties).build();
                                            Throwable throwable = null;
                                            try {
                                                LOG.warn(String.format("Peer %s in the group %s went down. Hence closing the log %s serve by the group.", raftPeer.toString(), group.toString(), logName.toString()));
                                                RaftClientReply reply = client.io().send(() -> LogServiceProtoUtil.toChangeStateRequestProto(logName, LogStream.State.CLOSED, true).toByteString());
                                                LogServiceProtos.ChangeStateReplyProto message = LogServiceProtos.ChangeStateReplyProto.parseFrom(reply.getMessage().getContent());
                                                if (message.hasException()) {
                                                    throw new IOException(message.getException().getErrorMsg());
                                                }
                                                itr.remove();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable = throwable2;
                                                throw throwable2;
                                            }
                                            finally {
                                                if (client == null) continue;
                                                if (throwable != null) {
                                                    try {
                                                        client.close();
                                                    }
                                                    catch (Throwable throwable3) {
                                                        throwable.addSuppressed(throwable3);
                                                    }
                                                    continue;
                                                }
                                                client.close();
                                            }
                                        }
                                        catch (IOException e) {
                                            LOG.warn(String.format("Failed to close log %s on peer %s failure.", logName, raftPeer.toString()), (Throwable)e);
                                        }
                                    }
                                    if (logNames.isEmpty()) {
                                        MetaStateMachine.this.peerLogs.remove(raftPeer);
                                        MetaStateMachine.this.heartbeatInfo.remove(raftPeer);
                                    }
                                }
                                ArrayList peerGroupsToRemove = new ArrayList();
                                MetaStateMachine.this.avail.stream().forEach(peerGroup -> {
                                    if (peerGroup.getPeer().equals(raftPeer)) {
                                        peerGroupsToRemove.add(peerGroup);
                                    }
                                });
                                for (PeerGroups peerGroups : peerGroupsToRemove) {
                                    MetaStateMachine.this.avail.remove(peerGroups);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception while closing logs and removing peer from raft groups with Metadata Service on node failure", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    static class PeerGroups
    implements Comparable {
        private RaftPeer peer;
        private Set<RaftGroup> groups = new HashSet<RaftGroup>();

        PeerGroups(RaftPeer peer) {
            this.peer = peer;
        }

        public Set<RaftGroup> getGroups() {
            return this.groups;
        }

        public RaftPeer getPeer() {
            return this.peer;
        }

        @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
        public int compareTo(Object o) {
            return this.groups.size() - ((PeerGroups)o).groups.size();
        }
    }
}

