/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.server.ServerOpts;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.TimeDuration;

public abstract class BaseServer
implements Closeable {
    private final ServerOpts opts;
    private final LogServiceConfiguration config;

    public BaseServer(ServerOpts opts) {
        this.opts = Objects.requireNonNull(opts);
        this.config = LogServiceConfiguration.create();
    }

    public ServerOpts getServerOpts() {
        return this.opts;
    }

    public LogServiceConfiguration getConfig() {
        return this.config;
    }

    void setRaftProperties(RaftProperties properties) {
        GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.opts.getPort());
        NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.opts.getPort());
        long leaderElectionTimeoutMinVal = this.getLeaderElectionTimeoutMin();
        TimeDuration leaderElectionTimeoutMin = TimeDuration.valueOf((long)leaderElectionTimeoutMinVal, (TimeUnit)TimeUnit.MILLISECONDS);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)leaderElectionTimeoutMin);
        long leaderElectionTimeoutMaxVal = this.getLeaderElectionTimeoutMax();
        TimeDuration leaderElectionMaxTimeout = TimeDuration.valueOf((long)leaderElectionTimeoutMaxVal, (TimeUnit)TimeUnit.MILLISECONDS);
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)leaderElectionMaxTimeout);
    }

    private long getLeaderElectionTimeoutMin() {
        return this.config.getLong("logservice.raft.leader.election.timeout.min", 1000L);
    }

    private long getLeaderElectionTimeoutMax() {
        return this.config.getLong("logservice.raft.leader.election.timeout.max", 1200L);
    }

    void validateRaftProperties(RaftProperties properties) {
        if (RaftServerConfigKeys.Snapshot.autoTriggerEnabled((RaftProperties)properties)) {
            throw new IllegalStateException("Auto triggering snapshots is disallowed by the LogService");
        }
    }

    static ServerOpts buildOpts(String hostname, String metaQuorum, int port, String workingDir) {
        ServerOpts opts = new ServerOpts();
        opts.setHost(hostname);
        opts.setMetaQuorum(metaQuorum);
        opts.setPort(port);
        opts.setWorkingDir(workingDir);
        return opts;
    }

    public static abstract class Builder<T extends BaseServer> {
        private ServerOpts opts = new ServerOpts();

        protected ServerOpts getOpts() {
            return this.opts;
        }

        public abstract T build();

        public Builder<T> validate() {
            if (!this.opts.isPortSet()) {
                InetSocketAddress addr = NetUtils.createLocalServerAddress();
                this.opts.setPort(addr.getPort());
            }
            if (!this.opts.isHostSet()) {
                this.opts.setHost(LogServiceUtils.getHostName());
            }
            if (!this.opts.isWorkingDirSet()) {
                throw new IllegalArgumentException("Working directory was not specified");
            }
            return this;
        }

        public Builder<T> setMetaQuorum(String meta) {
            this.opts.setMetaQuorum(meta);
            return this;
        }

        public Builder<T> setPort(int port) {
            this.opts.setPort(port);
            return this;
        }

        public Builder<T> setWorkingDir(String workingDir) {
            this.opts.setWorkingDir(workingDir);
            return this;
        }

        public Builder<T> setHostName(String hostName) {
            this.opts.setHost(hostName);
            return this;
        }
    }
}

