/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;

public class ArchivalInfo {
    private String archiveLocation;
    private LogName archiveLogName;
    private long lastArchivedIndex;
    private ArchivalStatus status;

    public ArchivalInfo(String location) {
        this.archiveLocation = location;
    }

    public ArchivalInfo updateArchivalInfo(LogServiceProtos.ArchiveLogRequestProto archiveLog) {
        this.archiveLogName = LogServiceProtoUtil.toLogName(archiveLog.getLogName());
        this.lastArchivedIndex = archiveLog.getLastArchivedRaftIndex();
        this.status = ArchivalStatus.valueOf(archiveLog.getStatus().name());
        return this;
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    public LogName getArchiveLogName() {
        return this.archiveLogName;
    }

    public long getLastArchivedIndex() {
        return this.lastArchivedIndex;
    }

    public ArchivalStatus getStatus() {
        return this.status;
    }

    public static enum ArchivalStatus {
        SUBMITTED,
        STARTED,
        RUNNING,
        INTERRUPTED,
        COMPLETED,
        FAILED;

    }
}

