/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.api.LogWriter;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWriterImpl
implements LogWriter {
    public static final Logger LOG = LoggerFactory.getLogger(LogWriterImpl.class);
    private LogStream parent;
    private RaftClient raftClient;
    private LogServiceConfiguration config;

    public LogWriterImpl(LogStream logStream) {
        this.parent = logStream;
        this.raftClient = logStream.getRaftClient();
        this.config = logStream.getConfiguration();
    }

    @Override
    public long write(ByteBuffer data) throws IOException {
        return this.write(Collections.singletonList(data)).get(0);
    }

    @Override
    public List<Long> write(List<ByteBuffer> list) throws IOException {
        try {
            RaftClientReply reply = this.raftClient.io().send(Message.valueOf((ByteString)LogServiceProtoUtil.toAppendBBEntryLogRequestProto(this.parent.getName(), list).toByteString()));
            if (reply.getException() != null) {
                throw new IOException((Throwable)reply.getException());
            }
            LogServiceProtos.AppendLogEntryReplyProto proto = LogServiceProtos.AppendLogEntryReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            List<Long> ids = proto.getRecordIdList();
            return ids;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long sync() throws IOException {
        try {
            RaftClientReply reply = this.raftClient.io().send(Message.valueOf((ByteString)LogServiceProtoUtil.toSyncLogRequestProto(this.parent.getName()).toByteString()));
            if (reply.getException() != null) {
                throw new IOException((Throwable)reply.getException());
            }
            LogServiceProtos.SyncLogReplyProto proto = LogServiceProtos.SyncLogReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            return proto.getLastRecordId();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

