/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.metrics.intercept.client;

import org.apache.ratis.grpc.metrics.MessageMetrics;
import org.apache.ratis.grpc.metrics.intercept.client.MetricClientCall;
import org.apache.ratis.thirdparty.io.grpc.CallOptions;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ClientCall;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;

public class MetricClientInterceptor
implements ClientInterceptor {
    private final String identifier;
    private final MessageMetrics metrics;

    public MetricClientInterceptor(String identifier) {
        this.identifier = identifier;
        this.metrics = new MessageMetrics(identifier, "client");
    }

    private String getMethodMetricPrefix(MethodDescriptor<?, ?> method) {
        String serviceName = MethodDescriptor.extractFullServiceName((String)method.getFullMethodName());
        String methodName = method.getFullMethodName().substring(serviceName.length() + 1);
        return this.identifier + "_" + serviceName + "_" + methodName;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new MetricClientCall(channel.newCall(methodDescriptor, callOptions), this.metrics, this.getMethodMetricPrefix(methodDescriptor));
    }
}

