/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftServerConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerConfigKeys.class);
    public static final String PREFIX = "raft.server";
    public static final String STORAGE_DIR_KEY = "raft.server.storage.dir";
    public static final List<File> STORAGE_DIR_DEFAULT = Collections.singletonList(new File("/tmp/raft-server/"));
    public static final String STORAGE_FREE_SPACE_MIN_KEY = "raft.server.storage.free-space.min";
    public static final SizeInBytes STORAGE_FREE_SPACE_MIN_DEFAULT = SizeInBytes.valueOf((String)"0MB");
    public static final String REMOVED_GROUPS_DIR_KEY = "raft.server.removed.groups.dir";
    public static final File REMOVED_GROUPS_DIR_DEFAULT = new File("/tmp/raft-server/removed-groups/");
    public static final String SLEEP_DEVIATION_THRESHOLD_KEY = "raft.server.sleep.deviation.threshold";
    public static final TimeDuration SLEEP_DEVIATION_THRESHOLD_DEFAULT = TimeDuration.valueOf((long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
    public static final String STAGING_CATCHUP_GAP_KEY = "raft.server.staging.catchup.gap";
    public static final int STAGING_CATCHUP_GAP_DEFAULT = 1000;

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).info(arg_0);
    }

    public static List<File> storageDir(RaftProperties properties) {
        return ConfUtils.getFiles((arg_0, arg_1) -> ((RaftProperties)properties).getFiles(arg_0, arg_1), (String)STORAGE_DIR_KEY, STORAGE_DIR_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setStorageDir(RaftProperties properties, List<File> storageDir) {
        ConfUtils.setFiles((arg_0, arg_1) -> ((RaftProperties)properties).setFiles(arg_0, arg_1), (String)STORAGE_DIR_KEY, storageDir, (BiConsumer[])new BiConsumer[0]);
    }

    public static SizeInBytes storageFreeSpaceMin(RaftProperties properties) {
        return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)STORAGE_FREE_SPACE_MIN_KEY, (SizeInBytes)STORAGE_FREE_SPACE_MIN_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setStorageFreeSpaceMin(RaftProperties properties, SizeInBytes storageFreeSpaceMin) {
        ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)STORAGE_FREE_SPACE_MIN_KEY, (SizeInBytes)storageFreeSpaceMin, (BiConsumer[])new BiConsumer[0]);
    }

    public static File removedGroupsDir(RaftProperties properties) {
        return ConfUtils.getFile((arg_0, arg_1) -> ((RaftProperties)properties).getFile(arg_0, arg_1), (String)REMOVED_GROUPS_DIR_KEY, (File)REMOVED_GROUPS_DIR_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setRemovedGroupsDir(RaftProperties properties, File removedGroupsStorageDir) {
        ConfUtils.setFile((arg_0, arg_1) -> ((RaftProperties)properties).setFile(arg_0, arg_1), (String)REMOVED_GROUPS_DIR_KEY, (File)removedGroupsStorageDir, (BiConsumer[])new BiConsumer[0]);
    }

    public static TimeDuration sleepDeviationThreshold(RaftProperties properties) {
        return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(SLEEP_DEVIATION_THRESHOLD_DEFAULT.getUnit()), (String)SLEEP_DEVIATION_THRESHOLD_KEY, (TimeDuration)SLEEP_DEVIATION_THRESHOLD_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setSleepDeviationThreshold(RaftProperties properties, int thresholdMs) {
        ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)SLEEP_DEVIATION_THRESHOLD_KEY, (int)thresholdMs, (BiConsumer[])new BiConsumer[0]);
    }

    public static int stagingCatchupGap(RaftProperties properties) {
        return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)STAGING_CATCHUP_GAP_KEY, (int)1000, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
    }

    public static void setStagingCatchupGap(RaftProperties properties, int stagingCatchupGap) {
        ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)STAGING_CATCHUP_GAP_KEY, (int)stagingCatchupGap, (BiConsumer[])new BiConsumer[0]);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftServerConfigKeys.class);
    }

    public static interface LeaderElection {
        public static final String PREFIX = "raft.server." + JavaUtils.getClassSimpleName(LeaderElection.class).toLowerCase();
        public static final String LEADER_STEP_DOWN_WAIT_TIME_KEY = PREFIX + ".leader.step-down.wait-time";
        public static final TimeDuration LEADER_STEP_DOWN_WAIT_TIME_DEFAULT = TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS);
        public static final String PRE_VOTE_KEY = PREFIX + ".pre-vote";
        public static final boolean PRE_VOTE_DEFAULT = true;

        public static TimeDuration leaderStepDownWaitTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(LEADER_STEP_DOWN_WAIT_TIME_DEFAULT.getUnit()), (String)LEADER_STEP_DOWN_WAIT_TIME_KEY, (TimeDuration)LEADER_STEP_DOWN_WAIT_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setLeaderStepDownWaitTime(RaftProperties properties, TimeDuration noLeaderTimeout) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)LEADER_STEP_DOWN_WAIT_TIME_KEY, (TimeDuration)noLeaderTimeout, (BiConsumer[])new BiConsumer[0]);
        }

        public static boolean preVote(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)PRE_VOTE_KEY, (boolean)true, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setPreVote(RaftProperties properties, boolean enablePreVote) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)PRE_VOTE_KEY, (boolean)enablePreVote, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Notification {
        public static final String PREFIX = "raft.server." + JavaUtils.getClassSimpleName(Notification.class).toLowerCase();
        public static final String NO_LEADER_TIMEOUT_KEY = PREFIX + ".no-leader.timeout";
        public static final TimeDuration NO_LEADER_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS);

        public static TimeDuration noLeaderTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(NO_LEADER_TIMEOUT_DEFAULT.getUnit()), (String)NO_LEADER_TIMEOUT_KEY, (TimeDuration)NO_LEADER_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setNoLeaderTimeout(RaftProperties properties, TimeDuration noLeaderTimeout) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)NO_LEADER_TIMEOUT_KEY, (TimeDuration)noLeaderTimeout, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface RetryCache {
        public static final String PREFIX = "raft.server.retrycache";
        public static final String EXPIRY_TIME_KEY = "raft.server.retrycache.expirytime";
        public static final TimeDuration EXPIRY_TIME_DEFAULT = TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS);
        public static final String STATISTICS_EXPIRY_TIME_KEY = "raft.server.retrycache.statistics.expirytime";
        public static final TimeDuration STATISTICS_EXPIRY_TIME_DEFAULT = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MICROSECONDS);

        public static TimeDuration expiryTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(EXPIRY_TIME_DEFAULT.getUnit()), (String)EXPIRY_TIME_KEY, (TimeDuration)EXPIRY_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setExpiryTime(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)EXPIRY_TIME_KEY, (TimeDuration)expiryTime, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration statisticsExpiryTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(STATISTICS_EXPIRY_TIME_DEFAULT.getUnit()), (String)STATISTICS_EXPIRY_TIME_KEY, (TimeDuration)STATISTICS_EXPIRY_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setStatisticsExpiryTime(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)STATISTICS_EXPIRY_TIME_KEY, (TimeDuration)expiryTime, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Rpc {
        public static final String PREFIX = "raft.server.rpc";
        public static final String TIMEOUT_MIN_KEY = "raft.server.rpc.timeout.min";
        public static final TimeDuration TIMEOUT_MIN_DEFAULT = TimeDuration.valueOf((long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String TIMEOUT_MAX_KEY = "raft.server.rpc.timeout.max";
        public static final TimeDuration TIMEOUT_MAX_DEFAULT = TimeDuration.valueOf((long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String REQUEST_TIMEOUT_KEY = "raft.server.rpc.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String SLEEP_TIME_KEY = "raft.server.rpc.sleep.time";
        public static final TimeDuration SLEEP_TIME_DEFAULT = TimeDuration.valueOf((long)25L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String SLOWNESS_TIMEOUT_KEY = "raft.server.rpc.slowness.timeout";
        public static final TimeDuration SLOWNESS_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS);

        public static TimeDuration timeoutMin(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(TIMEOUT_MIN_DEFAULT.getUnit()), (String)TIMEOUT_MIN_KEY, (TimeDuration)TIMEOUT_MIN_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setTimeoutMin(RaftProperties properties, TimeDuration minDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)TIMEOUT_MIN_KEY, (TimeDuration)minDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration timeoutMax(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(TIMEOUT_MAX_DEFAULT.getUnit()), (String)TIMEOUT_MAX_KEY, (TimeDuration)TIMEOUT_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setTimeoutMax(RaftProperties properties, TimeDuration maxDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)TIMEOUT_MAX_KEY, (TimeDuration)maxDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)REQUEST_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)timeoutDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration sleepTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(SLEEP_TIME_DEFAULT.getUnit()), (String)SLEEP_TIME_KEY, (TimeDuration)SLEEP_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSleepTime(RaftProperties properties, TimeDuration sleepTime) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)SLEEP_TIME_KEY, (TimeDuration)sleepTime, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration slownessTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(SLOWNESS_TIMEOUT_DEFAULT.getUnit()), (String)SLOWNESS_TIMEOUT_KEY, (TimeDuration)SLOWNESS_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSlownessTimeout(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)SLOWNESS_TIMEOUT_KEY, (TimeDuration)expiryTime, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface DataStream {
        public static final String PREFIX = "raft.server.data-stream";
        public static final String ASYNC_REQUEST_THREAD_POOL_SIZE_KEY = "raft.server.data-stream.async.request.thread.pool.size";
        public static final int ASYNC_REQUEST_THREAD_POOL_SIZE_DEFAULT = 32;
        public static final String ASYNC_WRITE_THREAD_POOL_SIZE_KEY = "raft.server.data-stream.async.write.thread.pool.size";
        public static final int ASYNC_WRITE_THREAD_POOL_SIZE_DEFAULT = 16;
        public static final String CLIENT_POOL_SIZE_KEY = "raft.server.data-stream.client.pool.size";
        public static final int CLIENT_POOL_SIZE_DEFAULT = 10;

        public static int asyncRequestThreadPoolSize(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)ASYNC_REQUEST_THREAD_POOL_SIZE_KEY, (int)32, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setAsyncRequestThreadPoolSize(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)ASYNC_REQUEST_THREAD_POOL_SIZE_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static int asyncWriteThreadPoolSize(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)ASYNC_WRITE_THREAD_POOL_SIZE_KEY, (int)16, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setAsyncWriteThreadPoolSize(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)ASYNC_WRITE_THREAD_POOL_SIZE_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static int clientPoolSize(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)CLIENT_POOL_SIZE_KEY, (int)10, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setClientPoolSize(RaftProperties properties, int num) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)CLIENT_POOL_SIZE_KEY, (int)num, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Snapshot {
        public static final String PREFIX = "raft.server.snapshot";
        public static final String AUTO_TRIGGER_ENABLED_KEY = "raft.server.snapshot.auto.trigger.enabled";
        public static final boolean AUTO_TRIGGER_ENABLED_DEFAULT = false;
        public static final String AUTO_TRIGGER_THRESHOLD_KEY = "raft.server.snapshot.auto.trigger.threshold";
        public static final long AUTO_TRIGGER_THRESHOLD_DEFAULT = 400000L;
        public static final String RETENTION_FILE_NUM_KEY = "raft.server.snapshot.retention.file.num";
        public static final int RETENTION_FILE_NUM_DEFAULT = -1;

        public static boolean autoTriggerEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)AUTO_TRIGGER_ENABLED_KEY, (boolean)false, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setAutoTriggerEnabled(RaftProperties properties, boolean autoTriggerThreshold) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)AUTO_TRIGGER_ENABLED_KEY, (boolean)autoTriggerThreshold, (BiConsumer[])new BiConsumer[0]);
        }

        public static long autoTriggerThreshold(RaftProperties properties) {
            return ConfUtils.getLong((arg_0, arg_1) -> ((RaftProperties)properties).getLong(arg_0, arg_1), (String)AUTO_TRIGGER_THRESHOLD_KEY, (long)400000L, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((long)0L)});
        }

        public static void setAutoTriggerThreshold(RaftProperties properties, long autoTriggerThreshold) {
            ConfUtils.setLong((arg_0, arg_1) -> ((RaftProperties)properties).setLong(arg_0, arg_1), (String)AUTO_TRIGGER_THRESHOLD_KEY, (long)autoTriggerThreshold, (BiConsumer[])new BiConsumer[0]);
        }

        public static int retentionFileNum(RaftProperties raftProperties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)raftProperties).getInt(arg_0, arg_1), (String)RETENTION_FILE_NUM_KEY, (int)-1, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setRetentionFileNum(RaftProperties properties, int numSnapshotFilesRetained) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)RETENTION_FILE_NUM_KEY, (int)numSnapshotFilesRetained, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Log {
        public static final String PREFIX = "raft.server.log";
        public static final String USE_MEMORY_KEY = "raft.server.log.use.memory";
        public static final boolean USE_MEMORY_DEFAULT = false;
        public static final String QUEUE_ELEMENT_LIMIT_KEY = "raft.server.log.queue.element-limit";
        public static final int QUEUE_ELEMENT_LIMIT_DEFAULT = 4096;
        public static final String QUEUE_BYTE_LIMIT_KEY = "raft.server.log.queue.byte-limit";
        public static final SizeInBytes QUEUE_BYTE_LIMIT_DEFAULT = SizeInBytes.valueOf((String)"64MB");
        public static final String PURGE_GAP_KEY = "raft.server.log.purge.gap";
        public static final int PURGE_GAP_DEFAULT = 1024;
        public static final String PURGE_UPTO_SNAPSHOT_INDEX_KEY = "raft.server.log.purge.upto.snapshot.index";
        public static final boolean PURGE_UPTO_SNAPSHOT_INDEX_DEFAULT = false;
        public static final String SEGMENT_SIZE_MAX_KEY = "raft.server.log.segment.size.max";
        public static final SizeInBytes SEGMENT_SIZE_MAX_DEFAULT = SizeInBytes.valueOf((String)"8MB");
        public static final String SEGMENT_CACHE_NUM_MAX_KEY = "raft.server.log.segment.cache.num.max";
        public static final int SEGMENT_CACHE_NUM_MAX_DEFAULT = 6;
        public static final String SEGMENT_CACHE_SIZE_MAX_KEY = "raft.server.log.segment.cache.size.max";
        public static final SizeInBytes SEGMENT_CACHE_SIZE_MAX_DEFAULT = SizeInBytes.valueOf((String)"200MB");
        public static final String PREALLOCATED_SIZE_KEY = "raft.server.log.preallocated.size";
        public static final SizeInBytes PREALLOCATED_SIZE_DEFAULT = SizeInBytes.valueOf((String)"4MB");
        public static final String WRITE_BUFFER_SIZE_KEY = "raft.server.log.write.buffer.size";
        public static final SizeInBytes WRITE_BUFFER_SIZE_DEFAULT = SizeInBytes.valueOf((String)"64KB");
        public static final String FORCE_SYNC_NUM_KEY = "raft.server.log.force.sync.num";
        public static final int FORCE_SYNC_NUM_DEFAULT = 128;
        public static final String CORRUPTION_POLICY_KEY = "raft.server.log.corruption.policy";
        public static final CorruptionPolicy CORRUPTION_POLICY_DEFAULT = CorruptionPolicy.getDefault();

        public static boolean useMemory(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)USE_MEMORY_KEY, (boolean)false, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setUseMemory(RaftProperties properties, boolean useMemory) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)USE_MEMORY_KEY, (boolean)useMemory, (BiConsumer[])new BiConsumer[0]);
        }

        public static int queueElementLimit(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)QUEUE_ELEMENT_LIMIT_KEY, (int)4096, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static void setQueueElementLimit(RaftProperties properties, int queueSize) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)QUEUE_ELEMENT_LIMIT_KEY, (int)queueSize, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static SizeInBytes queueByteLimit(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)QUEUE_BYTE_LIMIT_KEY, (SizeInBytes)QUEUE_BYTE_LIMIT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setQueueByteLimit(RaftProperties properties, int queueSize) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)QUEUE_BYTE_LIMIT_KEY, (int)queueSize, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static int purgeGap(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)PURGE_GAP_KEY, (int)1024, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static void setPurgeGap(RaftProperties properties, int purgeGap) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)PURGE_GAP_KEY, (int)purgeGap, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static boolean purgeUptoSnapshotIndex(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)PURGE_UPTO_SNAPSHOT_INDEX_KEY, (boolean)false, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setPurgeUptoSnapshotIndex(RaftProperties properties, boolean shouldPurgeUptoSnapshotIndex) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)PURGE_UPTO_SNAPSHOT_INDEX_KEY, (boolean)shouldPurgeUptoSnapshotIndex, (BiConsumer[])new BiConsumer[0]);
        }

        public static SizeInBytes segmentSizeMax(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)SEGMENT_SIZE_MAX_KEY, (SizeInBytes)SEGMENT_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSegmentSizeMax(RaftProperties properties, SizeInBytes segmentSizeMax) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)SEGMENT_SIZE_MAX_KEY, (SizeInBytes)segmentSizeMax, (BiConsumer[])new BiConsumer[0]);
        }

        public static int segmentCacheNumMax(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)SEGMENT_CACHE_NUM_MAX_KEY, (int)6, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setSegmentCacheNumMax(RaftProperties properties, int maxCachedSegmentNum) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)SEGMENT_CACHE_NUM_MAX_KEY, (int)maxCachedSegmentNum, (BiConsumer[])new BiConsumer[0]);
        }

        public static SizeInBytes segmentCacheSizeMax(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)SEGMENT_CACHE_SIZE_MAX_KEY, (SizeInBytes)SEGMENT_CACHE_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSegmentCacheSizeMax(RaftProperties properties, SizeInBytes maxCachedSegmentSize) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)SEGMENT_CACHE_SIZE_MAX_KEY, (SizeInBytes)maxCachedSegmentSize, (BiConsumer[])new BiConsumer[0]);
        }

        public static SizeInBytes preallocatedSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)PREALLOCATED_SIZE_KEY, (SizeInBytes)PREALLOCATED_SIZE_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setPreallocatedSize(RaftProperties properties, SizeInBytes preallocatedSize) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)PREALLOCATED_SIZE_KEY, (SizeInBytes)preallocatedSize, (BiConsumer[])new BiConsumer[0]);
        }

        public static SizeInBytes writeBufferSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)WRITE_BUFFER_SIZE_KEY, (SizeInBytes)WRITE_BUFFER_SIZE_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setWriteBufferSize(RaftProperties properties, SizeInBytes writeBufferSize) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)WRITE_BUFFER_SIZE_KEY, (SizeInBytes)writeBufferSize, (BiConsumer[])new BiConsumer[0]);
        }

        public static int forceSyncNum(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)FORCE_SYNC_NUM_KEY, (int)128, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setForceSyncNum(RaftProperties properties, int forceSyncNum) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)FORCE_SYNC_NUM_KEY, (int)forceSyncNum, (BiConsumer[])new BiConsumer[0]);
        }

        public static CorruptionPolicy corruptionPolicy(RaftProperties properties) {
            return (CorruptionPolicy)((Object)ConfUtils.get((arg_0, arg_1) -> ((RaftProperties)properties).getEnum(arg_0, arg_1), (String)CORRUPTION_POLICY_KEY, (Object)((Object)CORRUPTION_POLICY_DEFAULT), RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]));
        }

        public static void setCorruptionPolicy(RaftProperties properties, CorruptionPolicy corruptionPolicy) {
            ConfUtils.set((arg_0, arg_1) -> ((RaftProperties)properties).setEnum(arg_0, arg_1), (String)CORRUPTION_POLICY_KEY, (Object)((Object)corruptionPolicy), (BiConsumer[])new BiConsumer[0]);
        }

        public static interface Appender {
            public static final String PREFIX = "raft.server.log.appender";
            public static final String BUFFER_ELEMENT_LIMIT_KEY = "raft.server.log.appender.buffer.element-limit";
            public static final int BUFFER_ELEMENT_LIMIT_DEFAULT = 0;
            public static final String BUFFER_BYTE_LIMIT_KEY = "raft.server.log.appender.buffer.byte-limit";
            public static final SizeInBytes BUFFER_BYTE_LIMIT_DEFAULT = SizeInBytes.valueOf((String)"4MB");
            public static final String SNAPSHOT_CHUNK_SIZE_MAX_KEY = "raft.server.log.appender.snapshot.chunk.size.max";
            public static final SizeInBytes SNAPSHOT_CHUNK_SIZE_MAX_DEFAULT = SizeInBytes.valueOf((String)"16MB");
            public static final String INSTALL_SNAPSHOT_ENABLED_KEY = "raft.server.log.appender.install.snapshot.enabled";
            public static final boolean INSTALL_SNAPSHOT_ENABLED_DEFAULT = true;

            public static int bufferElementLimit(RaftProperties properties) {
                return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)BUFFER_ELEMENT_LIMIT_KEY, (int)0, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
            }

            public static void setBufferElementLimit(RaftProperties properties, int bufferElementLimit) {
                ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)BUFFER_ELEMENT_LIMIT_KEY, (int)bufferElementLimit, (BiConsumer[])new BiConsumer[0]);
            }

            public static SizeInBytes bufferByteLimit(RaftProperties properties) {
                return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)BUFFER_BYTE_LIMIT_KEY, (SizeInBytes)BUFFER_BYTE_LIMIT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setBufferByteLimit(RaftProperties properties, SizeInBytes bufferByteLimit) {
                ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)BUFFER_BYTE_LIMIT_KEY, (SizeInBytes)bufferByteLimit, (BiConsumer[])new BiConsumer[0]);
            }

            public static SizeInBytes snapshotChunkSizeMax(RaftProperties properties) {
                return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)SNAPSHOT_CHUNK_SIZE_MAX_KEY, (SizeInBytes)SNAPSHOT_CHUNK_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setSnapshotChunkSizeMax(RaftProperties properties, SizeInBytes maxChunkSize) {
                ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)SNAPSHOT_CHUNK_SIZE_MAX_KEY, (SizeInBytes)maxChunkSize, (BiConsumer[])new BiConsumer[0]);
            }

            public static boolean installSnapshotEnabled(RaftProperties properties) {
                return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)INSTALL_SNAPSHOT_ENABLED_KEY, (boolean)true, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setInstallSnapshotEnabled(RaftProperties properties, boolean shouldInstallSnapshot) {
                ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)INSTALL_SNAPSHOT_ENABLED_KEY, (boolean)shouldInstallSnapshot, (BiConsumer[])new BiConsumer[0]);
            }
        }

        public static interface StateMachineData {
            public static final String PREFIX = "raft.server.log.statemachine.data";
            public static final String SYNC_KEY = "raft.server.log.statemachine.data.sync";
            public static final boolean SYNC_DEFAULT = true;
            public static final String CACHING_ENABLED_KEY = "raft.server.log.statemachine.data.caching.enabled";
            public static final boolean CACHING_ENABLED_DEFAULT = false;
            public static final String SYNC_TIMEOUT_KEY = "raft.server.log.statemachine.data.sync.timeout";
            public static final TimeDuration SYNC_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS);
            public static final String SYNC_TIMEOUT_RETRY_KEY = "raft.server.log.statemachine.data.sync.timeout.retry";
            public static final int SYNC_TIMEOUT_RETRY_DEFAULT = -1;

            public static boolean sync(RaftProperties properties) {
                return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)SYNC_KEY, (boolean)true, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setSync(RaftProperties properties, boolean sync) {
                ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)SYNC_KEY, (boolean)sync, (BiConsumer[])new BiConsumer[0]);
            }

            public static boolean cachingEnabled(RaftProperties properties) {
                return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)CACHING_ENABLED_KEY, (boolean)false, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setCachingEnabled(RaftProperties properties, boolean enable) {
                ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)CACHING_ENABLED_KEY, (boolean)enable, (BiConsumer[])new BiConsumer[0]);
            }

            public static TimeDuration syncTimeout(RaftProperties properties) {
                return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(SYNC_TIMEOUT_DEFAULT.getUnit()), (String)SYNC_TIMEOUT_KEY, (TimeDuration)SYNC_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setSyncTimeout(RaftProperties properties, TimeDuration syncTimeout) {
                ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)SYNC_TIMEOUT_KEY, (TimeDuration)syncTimeout, (BiConsumer[])new BiConsumer[0]);
            }

            public static int syncTimeoutRetry(RaftProperties properties) {
                return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)SYNC_TIMEOUT_RETRY_KEY, (int)-1, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)-1)});
            }

            public static void setSyncTimeoutRetry(RaftProperties properties, int syncTimeoutRetry) {
                ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)SYNC_TIMEOUT_RETRY_KEY, (int)syncTimeoutRetry, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)-1)});
            }
        }

        public static enum CorruptionPolicy {
            EXCEPTION,
            WARN_AND_RETURN;


            public static CorruptionPolicy getDefault() {
                return EXCEPTION;
            }

            public static <T> CorruptionPolicy get(T supplier, Function<T, CorruptionPolicy> getMethod) {
                return Optional.ofNullable(supplier).map(getMethod).orElse(CorruptionPolicy.getDefault());
            }
        }
    }

    public static interface Watch {
        public static final String PREFIX = "raft.server.watch";
        public static final String ELEMENT_LIMIT_KEY = "raft.server.watch.element-limit";
        public static final int ELEMENT_LIMIT_DEFAULT = 65536;
        public static final String TIMEOUT_DENOMINATION_KEY = "raft.server.watch.timeout.denomination";
        public static final TimeDuration TIMEOUT_DENOMINATION_DEFAULT = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS);
        public static final String TIMEOUT_KEY = "raft.server.watch.timeout";
        public static final TimeDuration TIMEOUT_DEFAULT = TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS);

        public static int elementLimit(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)ELEMENT_LIMIT_KEY, (int)65536, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static void setElementLimit(RaftProperties properties, int limit) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)ELEMENT_LIMIT_KEY, (int)limit, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static TimeDuration timeoutDenomination(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(TIMEOUT_DENOMINATION_DEFAULT.getUnit()), (String)TIMEOUT_DENOMINATION_KEY, (TimeDuration)TIMEOUT_DENOMINATION_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requirePositive()});
        }

        public static void setTimeoutDenomination(RaftProperties properties, TimeDuration watchTimeout) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)TIMEOUT_DENOMINATION_KEY, (TimeDuration)watchTimeout, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration timeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(TIMEOUT_DEFAULT.getUnit()), (String)TIMEOUT_KEY, (TimeDuration)TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requirePositive()});
        }

        public static void setTimeout(RaftProperties properties, TimeDuration watchTimeout) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)TIMEOUT_KEY, (TimeDuration)watchTimeout, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Write {
        public static final String PREFIX = "raft.server.write";
        public static final String ELEMENT_LIMIT_KEY = "raft.server.write.element-limit";
        public static final int ELEMENT_LIMIT_DEFAULT = 4096;
        public static final String BYTE_LIMIT_KEY = "raft.server.write.byte-limit";
        public static final SizeInBytes BYTE_LIMIT_DEFAULT = SizeInBytes.valueOf((String)"64MB");

        public static int elementLimit(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)ELEMENT_LIMIT_KEY, (int)4096, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static void setElementLimit(RaftProperties properties, int limit) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)ELEMENT_LIMIT_KEY, (int)limit, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static SizeInBytes byteLimit(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)BYTE_LIMIT_KEY, (SizeInBytes)BYTE_LIMIT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setByteLimit(RaftProperties properties, SizeInBytes byteLimit) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)BYTE_LIMIT_KEY, (SizeInBytes)byteLimit, (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((long)1L)});
        }
    }
}

