/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.client.GrpcClientProtocolService;
import org.apache.ratis.grpc.server.GrpcAdminProtocolService;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcServerProtocolService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.RaftServerRpcWithProxy;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.ClientAuth;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcService
extends RaftServerRpcWithProxy<GrpcServerProtocolClient, PeerProxyMap<GrpcServerProtocolClient>> {
    static final Logger LOG = LoggerFactory.getLogger(GrpcService.class);
    public static final String GRPC_SEND_SERVER_REQUEST = GrpcService.class.getSimpleName() + ".sendRequest";
    private final Server server;
    private final Supplier<InetSocketAddress> addressSupplier;
    private final GrpcClientProtocolService clientProtocolService;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GrpcService(RaftServer server, GrpcTlsConfig tlsConfig) {
        this(server, () -> ((RaftServer)server).getId(), GrpcConfigKeys.Server.port(server.getProperties()), GrpcConfigKeys.messageSizeMax(server.getProperties(), arg_0 -> ((Logger)LOG).info(arg_0)), RaftServerConfigKeys.Log.Appender.bufferByteLimit((RaftProperties)server.getProperties()), GrpcConfigKeys.flowControlWindow(server.getProperties(), arg_0 -> ((Logger)LOG).info(arg_0)), RaftServerConfigKeys.Rpc.requestTimeout((RaftProperties)server.getProperties()), tlsConfig);
    }

    private GrpcService(RaftServer raftServer, Supplier<RaftPeerId> idSupplier, int port, SizeInBytes grpcMessageSizeMax, SizeInBytes appenderBufferSize, SizeInBytes flowControlWindow, TimeDuration requestTimeoutDuration, GrpcTlsConfig tlsConfig) {
        super(idSupplier, id -> new PeerProxyMap(id.toString(), p -> new GrpcServerProtocolClient((RaftPeer)p, flowControlWindow.getSizeInt(), requestTimeoutDuration, tlsConfig)));
        if (appenderBufferSize.getSize() > grpcMessageSizeMax.getSize()) {
            throw new IllegalArgumentException("Illegal configuration: raft.server.log.appender.buffer.byte-limit = " + appenderBufferSize + " > " + "raft.grpc.message.size.max" + " = " + grpcMessageSizeMax);
        }
        this.clientProtocolService = new GrpcClientProtocolService(idSupplier, (RaftClientAsynchronousProtocol)raftServer);
        NettyServerBuilder nettyServerBuilder = (NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)port).withChildOption(ChannelOption.SO_REUSEADDR, (Object)true).maxInboundMessageSize(grpcMessageSizeMax.getSizeInt()).flowControlWindow(flowControlWindow.getSizeInt()).addService((BindableService)new GrpcServerProtocolService(idSupplier, raftServer))).addService((BindableService)this.clientProtocolService)).addService((BindableService)new GrpcAdminProtocolService((AdminAsynchronousProtocol)raftServer));
        if (tlsConfig != null) {
            SslContextBuilder sslContextBuilder;
            SslContextBuilder sslContextBuilder2 = sslContextBuilder = tlsConfig.isFileBasedConfig() ? SslContextBuilder.forServer((File)tlsConfig.getCertChainFile(), (File)tlsConfig.getPrivateKeyFile()) : SslContextBuilder.forServer((PrivateKey)tlsConfig.getPrivateKey(), (X509Certificate[])new X509Certificate[]{tlsConfig.getCertChain()});
            if (tlsConfig.getMtlsEnabled()) {
                sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                if (tlsConfig.isFileBasedConfig()) {
                    sslContextBuilder.trustManager(tlsConfig.getTrustStoreFile());
                } else {
                    sslContextBuilder.trustManager(new X509Certificate[]{tlsConfig.getTrustStore()});
                }
            }
            sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.OPENSSL);
            try {
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to build SslContext, tlsConfig=" + tlsConfig, ex);
            }
        }
        this.server = nettyServerBuilder.build();
        this.addressSupplier = JavaUtils.memoize(() -> new InetSocketAddress(port != 0 ? port : this.server.getPort()));
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    public void startImpl() {
        try {
            this.server.start();
        }
        catch (IOException e) {
            ExitUtils.terminate((int)1, (String)"Failed to start Grpc server", (Throwable)e, (Logger)LOG);
        }
        LOG.info("{}: {} started, listening on {}", new Object[]{this.getId(), ((Object)((Object)this)).getClass().getSimpleName(), this.getInetSocketAddress()});
    }

    public void closeImpl() throws IOException {
        String name = this.getId() + ": shutdown server with port " + this.server.getPort();
        LOG.info("{} now", (Object)name);
        Server s = this.server.shutdownNow();
        super.closeImpl();
        try {
            s.awaitTermination();
        }
        catch (InterruptedException e) {
            throw IOUtils.toInterruptedIOException((String)(name + " failed"), (InterruptedException)e);
        }
        LOG.info("{} successfully", (Object)name);
    }

    public void notifyNotLeader(RaftGroupId groupId) {
        this.clientProtocolService.closeAllOrderedRequestStreamObservers(groupId);
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addressSupplier.get();
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)GRPC_SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        RaftPeerId target = RaftPeerId.valueOf((ByteString)request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)this.getProxies().getProxy(target)).requestVote(request);
    }

    public static final class Builder
    extends RaftServerRpc.Builder<Builder, GrpcService> {
        private GrpcTlsConfig tlsConfig;

        private Builder() {
        }

        public Builder getThis() {
            return this;
        }

        public GrpcService build() {
            return new GrpcService(this.getServer(), this.getTlsConfig());
        }

        public Builder setTlsConfig(GrpcTlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public GrpcTlsConfig getTlsConfig() {
            return this.tlsConfig;
        }
    }
}

