/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.function.Consumer;
import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.client.GrpcClientRpc;
import org.apache.ratis.grpc.server.GrpcLogAppender;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerFactory;
import org.apache.ratis.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcFactory
implements ServerFactory,
ClientFactory {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcFactory.class);
    private final GrpcTlsConfig tlsConfig;

    private void checkPooledByteBufAllocatorUseCacheForAllThreads(Consumer<String> log) {
        String name = "useCacheForAllThreads";
        String key = "org.apache.ratis.thirdparty.io.netty.allocator.useCacheForAllThreads";
        boolean value = PooledByteBufAllocator.defaultUseCacheForAllThreads();
        if (value) {
            log.accept("PERFORMANCE WARNING: useCacheForAllThreads is " + value + " that may cause Netty to create a lot garbage objects and, as a result, trigger GC.\n\tIt is recommended to disable " + "useCacheForAllThreads" + " by setting -D" + "org.apache.ratis.thirdparty.io.netty.allocator.useCacheForAllThreads" + "=" + !value + " in command line.");
        }
    }

    public static Parameters newRaftParameters(GrpcTlsConfig conf) {
        Parameters p = new Parameters();
        GrpcConfigKeys.TLS.setConf(p, conf);
        return p;
    }

    public GrpcFactory(Parameters parameters) {
        this(GrpcConfigKeys.TLS.conf(parameters));
    }

    public GrpcFactory(GrpcTlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public GrpcTlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    public LogAppender newLogAppender(RaftServerImpl server, LeaderState state, FollowerInfo f) {
        return new GrpcLogAppender(server, state, f);
    }

    public GrpcService newRaftServerRpc(RaftServer server) {
        this.checkPooledByteBufAllocatorUseCacheForAllThreads(arg_0 -> ((Logger)LOG).info(arg_0));
        return ((GrpcService.Builder)GrpcService.newBuilder().setServer(server)).setTlsConfig(this.tlsConfig).build();
    }

    public GrpcClientRpc newRaftClientRpc(ClientId clientId, RaftProperties properties) {
        this.checkPooledByteBufAllocatorUseCacheForAllThreads(arg_0 -> ((Logger)LOG).debug(arg_0));
        return new GrpcClientRpc(clientId, properties, this.getTlsConfig());
    }
}

