/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.util.UUID;
import org.apache.ratis.logservice.common.Constants;

public class ServerOpts {
    @Parameter(names={"-h", "--hostname"}, description="Hostname")
    private String host = null;
    @Parameter(names={"-p", "--port"}, description="Port number")
    private int port = -1;
    @Parameter(names={"-d", "--dir"}, description="Working directory")
    private String workingDir = null;
    @Parameter(names={"-q", "--metaQuorum"}, description="Metadata Service Quorum")
    private String metaQuorum = null;
    @Parameter(names={"--metadataServerGroupId"}, description="UUID corresponding to the RAFT metadata servers group", converter=UUIDConverter.class)
    private UUID metaGroupId = Constants.META_GROUP_UUID;
    @Parameter(names={"--logServerGroupId"}, description="UUID corresponding to the RAFT log servers group", converter=UUIDConverter.class)
    private UUID logServerGroupId = Constants.SERVERS_GROUP_UUID;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isHostSet() {
        return this.host != null;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isPortSet() {
        return this.port != -1;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean isWorkingDirSet() {
        return this.workingDir != null;
    }

    public String getMetaQuorum() {
        return this.metaQuorum;
    }

    public void setMetaQuorum(String metaQuorum) {
        this.metaQuorum = metaQuorum;
    }

    public boolean isMetaQuorumSet() {
        return this.metaQuorum != null;
    }

    public UUID getMetaGroupId() {
        return this.metaGroupId;
    }

    public void setMetaGroupId(UUID metaGroupId) {
        this.metaGroupId = metaGroupId;
    }

    public boolean isMetaServerGroupIdSet() {
        return this.metaGroupId != null && !this.metaGroupId.equals(Constants.META_GROUP_UUID);
    }

    public UUID getLogServerGroupId() {
        return this.logServerGroupId;
    }

    public void setLogServerGroupId(UUID logServerGroupId) {
        this.logServerGroupId = logServerGroupId;
    }

    public boolean isLogServerGroupIdSet() {
        return this.logServerGroupId != null && !this.logServerGroupId.equals(Constants.SERVERS_GROUP_UUID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hostname=").append(this.host);
        sb.append(", port=").append(this.port);
        sb.append(", dir=").append(this.workingDir);
        sb.append(", metaQuorum=").append(this.metaQuorum);
        sb.append(", metaGroupId=").append(this.metaGroupId);
        sb.append(", logServerGroupId=").append(this.logServerGroupId);
        return sb.toString();
    }

    static class UUIDConverter
    implements IStringConverter<UUID> {
        UUIDConverter() {
        }

        public UUID convert(String value) {
            return UUID.fromString(value);
        }
    }
}

