/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.server.RaftLogReader;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.ratis.thirdparty.com.google.protobuf.TextFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServiceRaftLogReader
implements RaftLogReader {
    private static final Logger LOG = LoggerFactory.getLogger(LogServiceRaftLogReader.class);
    private final RaftLog raftLog;
    private long currentRecordId = -1L;
    private long currentRaftIndex = -1L;
    private LogServiceProtos.AppendLogEntryRequestProto currentLogEntry = null;
    private int currentLogEntryOffset = -1;
    private ByteString currentRecord = null;

    public LogServiceRaftLogReader(RaftLog raftLog) {
        this.raftLog = Objects.requireNonNull(raftLog);
    }

    @Override
    public void seek(long recordId) throws RaftLogIOException, InvalidProtocolBufferException {
        LOG.trace("Seeking to recordId={}", (Object)recordId);
        this.currentRaftIndex = this.raftLog.getStartIndex();
        this.currentRecordId = 0L;
        this.currentLogEntry = null;
        this.currentLogEntryOffset = -1;
        this.currentRecord = null;
        this.loadNext();
        while (this.currentRecordId < recordId && this.hasNext()) {
            this.next();
            ++this.currentRecordId;
        }
    }

    @Override
    public boolean hasNext() throws RaftLogIOException, InvalidProtocolBufferException {
        return this.currentRecord != null;
    }

    @Override
    public byte[] next() throws RaftLogIOException, InvalidProtocolBufferException {
        if (this.currentRecord == null) {
            throw new NoSuchElementException();
        }
        ByteString current = this.currentRecord;
        this.currentRecord = null;
        this.loadNext();
        return current.toByteArray();
    }

    private void loadNext() throws RaftLogIOException, InvalidProtocolBufferException {
        this.currentRecord = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading next value: raftIndex={}, recordId={}, proto='{}', offset={}", new Object[]{this.currentRaftIndex, this.currentRecordId, this.currentLogEntry == null ? "null" : TextFormat.shortDebugString((MessageOrBuilder)this.currentLogEntry), this.currentLogEntryOffset});
        }
        if (this.currentLogEntry != null) {
            assert (this.currentLogEntryOffset != -1);
            ++this.currentLogEntryOffset;
            if (this.currentLogEntryOffset < this.currentLogEntry.getDataCount()) {
                this.currentRecord = this.currentLogEntry.getData(this.currentLogEntryOffset);
                return;
            }
            this.currentLogEntry = null;
            this.currentLogEntryOffset = -1;
            ++this.currentRaftIndex;
        }
        while (this.currentRaftIndex <= this.raftLog.getLastCommittedIndex()) {
            try {
                LogServiceProtos.LogServiceRequestProto logServiceProto;
                RaftProtos.LogEntryProto entry = this.raftLog.get(this.currentRaftIndex);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Raft Index: {} Entry: {}", (Object)this.currentRaftIndex, (Object)TextFormat.shortDebugString((MessageOrBuilder)entry));
                }
                if (entry != null && !entry.hasConfigurationEntry() && LogServiceProtos.LogServiceRequestProto.RequestCase.APPENDREQUEST == (logServiceProto = LogServiceProtos.LogServiceRequestProto.parseFrom(entry.getStateMachineLogEntry().getLogData())).getRequestCase()) {
                    this.currentLogEntry = logServiceProto.getAppendRequest();
                    this.currentLogEntryOffset = 0;
                    if (this.currentLogEntry.getDataCount() > 0) {
                        this.currentRecord = this.currentLogEntry.getData(this.currentLogEntryOffset);
                        return;
                    }
                    this.currentLogEntry = null;
                    this.currentLogEntryOffset = -1;
                }
            }
            catch (RaftLogIOException e) {
                LOG.error("Caught exception reading from RaftLog", (Throwable)e);
                throw e;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("Caught exception reading LogService protobuf from RaftLog", (Throwable)e);
                throw e;
            }
            ++this.currentRaftIndex;
        }
    }

    @Override
    public long getCurrentRaftIndex() {
        return this.currentRaftIndex;
    }
}

