/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.logservice.api.LogReader;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReaderImpl
implements LogReader {
    public static final Logger LOG = LoggerFactory.getLogger(LogReaderImpl.class);
    private LogStream parent;
    private RaftClient raftClient;
    private LogServiceConfiguration config;
    private long currentRecordId;

    public LogReaderImpl(LogStream logStream) {
        this.parent = logStream;
        this.raftClient = logStream.getRaftClient();
        this.config = logStream.getConfiguration();
    }

    @Override
    public void seek(long recordId) throws IOException {
        Preconditions.checkArgument((recordId >= 0L ? 1 : 0) != 0, (Object)"recordId must be >= 0");
        this.currentRecordId = recordId;
    }

    @Override
    public ByteBuffer readNext() throws IOException {
        try {
            RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toReadLogRequestProto(this.parent.getName(), this.currentRecordId, 1).toByteString()));
            LogServiceProtos.ReadLogReplyProto proto = LogServiceProtos.ReadLogReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            ++this.currentRecordId;
            if (proto.getLogRecordCount() > 0) {
                proto.getLogRecord(0);
                return ByteBuffer.wrap(proto.getLogRecord(0).toByteArray());
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readNext(ByteBuffer buffer) throws IOException {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer is NULL");
        try {
            RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toReadLogRequestProto(this.parent.getName(), this.currentRecordId, 1).toByteString()));
            LogServiceProtos.ReadLogReplyProto proto = LogServiceProtos.ReadLogReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            ++this.currentRecordId;
            if (proto.getLogRecordCount() > 0) {
                buffer.put(proto.getLogRecord(0).toByteArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<ByteBuffer> readBulk(int numRecords) throws IOException {
        Preconditions.checkArgument((numRecords > 0 ? 1 : 0) != 0, (Object)"number of records must be greater than 0");
        try {
            RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toReadLogRequestProto(this.parent.getName(), this.currentRecordId, numRecords).toByteString()));
            LogServiceProtos.ReadLogReplyProto proto = LogServiceProtos.ReadLogReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            int n = proto.getLogRecordCount();
            this.currentRecordId += (long)n;
            ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>();
            for (int i = 0; i < n; ++i) {
                ret.add(ByteBuffer.wrap(proto.getLogRecord(i).toByteArray()));
            }
            return ret;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readBulk(ByteBuffer[] buffers) throws IOException {
        Preconditions.checkNotNull((Object)buffers, (Object)"list of buffers is NULL");
        Preconditions.checkArgument((buffers.length > 0 ? 1 : 0) != 0, (Object)"list of buffers is empty");
        try {
            RaftClientReply reply = this.raftClient.sendReadOnly(Message.valueOf((ByteString)LogServiceProtoUtil.toReadLogRequestProto(this.parent.getName(), this.currentRecordId, buffers.length).toByteString()));
            LogServiceProtos.ReadLogReplyProto proto = LogServiceProtos.ReadLogReplyProto.parseFrom(reply.getMessage().getContent());
            if (proto.hasException()) {
                LogServiceProtos.LogServiceException e = proto.getException();
                throw new IOException(e.getErrorMsg());
            }
            int n = proto.getLogRecordCount();
            this.currentRecordId += (long)n;
            for (int i = 0; i < n; ++i) {
                buffers[i] = ByteBuffer.wrap(proto.getLogRecord(i).toByteArray());
            }
            return n;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getPosition() {
        return this.currentRecordId;
    }

    @Override
    public void close() throws IOException {
    }
}

