/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.impl;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ratis.logservice.api.ArchiveLogReader;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveHdfsLogReader
implements ArchiveLogReader {
    public static final Logger LOG = LoggerFactory.getLogger(ArchiveHdfsLogReader.class);
    private long fileLength;
    private List<FileStatus> files;
    private FileSystem hdfs;
    private FSDataInputStream is;
    private byte[] currentRecord;
    private int fileCounter = 0;
    private int currentRecordId;

    public ArchiveHdfsLogReader(String archiveLocation) throws IOException {
        this(new Configuration(), archiveLocation);
    }

    public ArchiveHdfsLogReader(Configuration configuration, String archiveLocation) throws IOException {
        this.hdfs = FileSystem.get((Configuration)configuration);
        Path archiveLocationPath = new Path(archiveLocation);
        if (!this.hdfs.exists(archiveLocationPath)) {
            throw new FileNotFoundException(archiveLocation);
        }
        this.files = Arrays.asList(this.hdfs.listStatus(archiveLocationPath));
        if (this.files.size() > 0) {
            Collections.sort(this.files, new Comparator<FileStatus>(){

                @Override
                public int compare(FileStatus o1, FileStatus o2) {
                    return LogServiceUtils.getRecordIdFromRolledArchiveFile(o1.getPath()).compareTo(LogServiceUtils.getRecordIdFromRolledArchiveFile(o2.getPath()));
                }
            });
            this.openNextFilePath();
            this.loadNext();
        }
    }

    private Path openNextFilePath() throws IOException {
        Path filePath = this.files.get(this.fileCounter).getPath();
        this.is = this.hdfs.open(filePath);
        this.fileLength = this.hdfs.getFileStatus(filePath).getLen();
        ++this.fileCounter;
        return filePath;
    }

    @Override
    public void seek(long recordId) throws IOException {
        while ((long)this.currentRecordId < recordId && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.currentRecord != null;
    }

    @Override
    public byte[] next() throws IOException {
        byte[] current = this.currentRecord;
        this.currentRecord = null;
        if (current != null) {
            ++this.currentRecordId;
        }
        this.loadNext();
        return current;
    }

    @Override
    public long getCurrentRaftIndex() {
        throw new UnsupportedOperationException("getCurrentRaftIndex() is not supported for archive hdfs log reader");
    }

    @Override
    public ByteBuffer readNext() throws IOException {
        byte[] current = this.next();
        if (current == null) {
            throw new NoSuchElementException();
        }
        return ByteBuffer.wrap(current);
    }

    private int readLength() throws IOException {
        int length;
        try {
            length = this.is.readInt();
        }
        catch (EOFException e) {
            if (this.files.size() <= this.fileCounter) {
                LOG.trace("EOF and no more file to read, throwing back", (Throwable)e);
                throw e;
            }
            LOG.trace("EOF.. Opening next file: {}!!", (Object)this.files.get(this.fileCounter).getPath());
            this.openNextFilePath();
            length = this.is.readInt();
        }
        return length;
    }

    @Override
    public void readNext(ByteBuffer buffer) throws IOException {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer is NULL");
        byte[] current = this.next();
        if (current == null) {
            throw new NoSuchElementException();
        }
        buffer.put(current);
    }

    @Override
    public List<ByteBuffer> readBulk(int numRecords) throws IOException {
        Preconditions.checkArgument((numRecords > 0 ? 1 : 0) != 0, (Object)"number of records must be greater than 0");
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>();
        try {
            for (int i = 0; i < numRecords; ++i) {
                ByteBuffer buffer = this.readNext();
                ret.add(buffer);
            }
        }
        catch (EOFException i) {}
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            return ret;
        }
    }

    @Override
    public int readBulk(ByteBuffer[] buffers) throws IOException {
        Preconditions.checkNotNull((Object)buffers, (Object)"list of buffers is NULL");
        Preconditions.checkArgument((buffers.length > 0 ? 1 : 0) != 0, (Object)"list of buffers is empty");
        int count = 0;
        try {
            for (int i = 0; i < buffers.length; ++i) {
                this.readNext(buffers[i]);
                ++count;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return count;
    }

    @Override
    public long getPosition() throws IOException {
        return this.currentRecordId;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
    }

    private void loadNext() throws IOException {
        int length;
        try {
            length = this.readLength();
        }
        catch (EOFException e) {
            this.currentRecord = null;
            return;
        }
        byte[] bytes = new byte[length];
        if (this.is.read(bytes) != length) {
            throw new EOFException("File seems to be corrupted, Encountered EOF before reading the complete record");
        }
        this.currentRecord = bytes;
    }

    public List<FileStatus> getFiles() {
        return this.files;
    }
}

