/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.api;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.LogInfo;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.common.Constants;
import org.apache.ratis.logservice.impl.ArchivedLogStreamImpl;
import org.apache.ratis.logservice.impl.ExportedLogStreamImpl;
import org.apache.ratis.logservice.impl.LogStreamImpl;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.proto.MetaServiceProtos;
import org.apache.ratis.logservice.server.ArchivalInfo;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.logservice.util.MetaServiceProtoUtil;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;

public class LogServiceClient
implements AutoCloseable {
    private final RaftClient client;
    private final LogServiceConfiguration config;

    public LogServiceClient(String metaQuorum) {
        this(metaQuorum, LogServiceConfiguration.create(), new RaftProperties());
    }

    public LogServiceClient(String metaQuorum, RaftProperties properties) {
        this(metaQuorum, LogServiceConfiguration.create(), properties);
    }

    public LogServiceClient(String metaQuorum, LogServiceConfiguration config, RaftProperties properties) {
        Set<RaftPeer> peers = LogServiceUtils.getPeersFromQuorum(metaQuorum);
        RaftGroup meta = RaftGroup.valueOf((RaftGroupId)Constants.META_GROUP_ID, peers);
        this.client = RaftClient.newBuilder().setRaftGroup(meta).setClientId(ClientId.randomId()).setProperties(properties).build();
        this.config = config;
    }

    public LogStream createLog(LogName logName) throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toCreateLogRequestProto(logName).toByteString());
        MetaServiceProtos.CreateLogReplyProto message = MetaServiceProtos.CreateLogReplyProto.parseFrom(reply.getMessage().getContent());
        if (message.hasException()) {
            throw MetaServiceProtoUtil.toMetaServiceException(message.getException());
        }
        LogInfo info = MetaServiceProtoUtil.toLogInfo(message.getLog());
        return new LogStreamImpl(logName, this.getRaftClient(info), this.config);
    }

    public LogStream getLog(LogName logName) throws IOException {
        return new LogStreamImpl(logName, this.getRaftClient(this.getLogInfo(logName)), this.config);
    }

    public LogStream getArchivedLog(LogName logName) throws IOException {
        return new ArchivedLogStreamImpl(logName, this.config);
    }

    public LogStream getExportLog(LogName logName, String location) throws IOException {
        return new ExportedLogStreamImpl(logName, location);
    }

    public List<ArchivalInfo> getExportStatus(LogName logName) throws IOException {
        try (RaftClient client = this.getRaftClient(this.getLogInfo(logName));){
            RaftClientReply exportInfoReply = client.sendReadOnly(() -> LogServiceProtoUtil.toExportInfoRequestProto(logName).toByteString());
            LogServiceProtos.GetExportInfoReplyProto message = LogServiceProtos.GetExportInfoReplyProto.parseFrom(exportInfoReply.getMessage().getContent());
            if (message.hasException()) {
                throw new IOException(message.getException().getErrorMsg());
            }
            List<ArchivalInfo> list = message.getInfoList().stream().map(infoProto -> LogServiceProtoUtil.toExportInfo(infoProto)).collect(Collectors.toList());
            return list;
        }
    }

    public void deleteLog(LogName logName) throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toDeleteLogRequestProto(logName).toByteString());
        MetaServiceProtos.DeleteLogReplyProto message = MetaServiceProtos.DeleteLogReplyProto.parseFrom(reply.getMessage().getContent());
        if (message.hasException()) {
            throw MetaServiceProtoUtil.toMetaServiceException(message.getException());
        }
    }

    public List<LogInfo> listLogs() throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toListLogRequestProto().toByteString());
        MetaServiceProtos.ListLogsReplyProto message = MetaServiceProtos.ListLogsReplyProto.parseFrom(reply.getMessage().getContent());
        List<MetaServiceProtos.LogInfoProto> infoProtos = message.getLogsList();
        List<LogInfo> infos = infoProtos.stream().map(proto -> MetaServiceProtoUtil.toLogInfo(proto)).collect(Collectors.toList());
        return infos;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private RaftClient getRaftClient(LogInfo logInfo) throws IOException {
        RaftProperties properties = new RaftProperties();
        return RaftClient.newBuilder().setRaftGroup(logInfo.getRaftGroup()).setProperties(properties).build();
    }

    private LogInfo getLogInfo(LogName logName) throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toGetLogRequestProto(logName).toByteString());
        MetaServiceProtos.GetLogReplyProto message = MetaServiceProtos.GetLogReplyProto.parseFrom(reply.getMessage().getContent());
        if (message.hasException()) {
            throw MetaServiceProtoUtil.toMetaServiceException(message.getException());
        }
        return MetaServiceProtoUtil.toLogInfo(message.getLog());
    }

    public void archiveLog(LogName logName) throws IOException {
        this.exportLog(logName, null, 0L);
    }

    public void exportLog(LogName logName, String location, long recordId) throws IOException {
        try (RaftClient client = this.getRaftClient(this.getLogInfo(logName));){
            RaftClientReply archiveLogReply = client.sendReadOnly(() -> LogServiceProtoUtil.toArchiveLogRequestProto(logName, location, recordId, location == null, ArchivalInfo.ArchivalStatus.SUBMITTED).toByteString());
            LogServiceProtos.ArchiveLogReplyProto archiveMessage = LogServiceProtos.ArchiveLogReplyProto.parseFrom(archiveLogReply.getMessage().getContent());
            if (archiveMessage.hasException()) {
                throw new IOException(archiveMessage.getException().getErrorMsg());
            }
        }
    }

    public void closeLog(LogName name) throws IOException {
        try (RaftClient client = this.getRaftClient(this.getLogInfo(name));){
            RaftClientReply reply = client.send(() -> LogServiceProtoUtil.toChangeStateRequestProto(name, LogStream.State.CLOSED).toByteString());
            LogServiceProtos.ChangeStateReplyProto changeStateReplyProto = LogServiceProtos.ChangeStateReplyProto.parseFrom(reply.getMessage().getContent());
        }
    }

    void updateConfiguration(LogName name, LogServiceConfiguration conf) {
    }
}

