/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogWorker;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;

public class SegmentedRaftLog
extends RaftLog {
    private final ServerLogMethods server;
    private final RaftStorage storage;
    private final StateMachine stateMachine;
    private final SegmentedRaftLogCache cache;
    private final SegmentedRaftLogWorker fileLogWorker;
    private final long segmentMaxSize;
    private final boolean stateMachineCachingEnabled;

    private ServerLogMethods newServerLogMethods(final RaftServerImpl impl) {
        if (impl == null) {
            return ServerLogMethods.DUMMY;
        }
        return new ServerLogMethods(){

            @Override
            public boolean shouldEvictCache() {
                return SegmentedRaftLog.this.cache.shouldEvict();
            }

            @Override
            public long[] getFollowerNextIndices() {
                return impl.getFollowerNextIndices();
            }

            @Override
            public long getLastAppliedIndex() {
                return impl.getState().getLastAppliedIndex();
            }

            @Override
            public void notifyTruncatedLogEntry(TermIndex ti) {
                try {
                    RaftProtos.LogEntryProto entry = SegmentedRaftLog.this.get(ti.getIndex());
                    impl.notifyTruncatedLogEntry(entry);
                }
                catch (RaftLogIOException e) {
                    RaftLog.LOG.error("{}: Failed to read log {}", new Object[]{SegmentedRaftLog.this.getName(), ti, e});
                }
            }
        };
    }

    public SegmentedRaftLog(RaftGroupMemberId memberId, RaftServerImpl server, RaftStorage storage, long lastIndexInSnapshot, RaftProperties properties) {
        this(memberId, server, server != null ? server.getStateMachine() : null, server != null ? server::submitUpdateCommitEvent : null, storage, lastIndexInSnapshot, properties);
    }

    SegmentedRaftLog(RaftGroupMemberId memberId, RaftServerImpl server, StateMachine stateMachine, Runnable submitUpdateCommitEvent, RaftStorage storage, long lastIndexInSnapshot, RaftProperties properties) {
        super(memberId, lastIndexInSnapshot, properties);
        this.server = this.newServerLogMethods(server);
        this.storage = storage;
        this.stateMachine = stateMachine;
        this.segmentMaxSize = RaftServerConfigKeys.Log.segmentSizeMax(properties).getSize();
        this.cache = new SegmentedRaftLogCache(memberId, storage, properties, this.getRaftLogMetrics());
        this.fileLogWorker = new SegmentedRaftLogWorker(memberId, stateMachine, submitUpdateCommitEvent, server, storage, properties, this.getRaftLogMetrics());
        this.stateMachineCachingEnabled = RaftServerConfigKeys.Log.StateMachineData.cachingEnabled(properties);
    }

    @Override
    protected void openImpl(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> consumer) throws IOException {
        this.loadLogSegments(lastIndexInSnapshot, consumer);
        File openSegmentFile = null;
        LogSegment openSegment = this.cache.getOpenSegment();
        if (openSegment != null) {
            openSegmentFile = this.storage.getStorageDir().getOpenLogFile(openSegment.getStartIndex());
        }
        this.fileLogWorker.start(Math.max(this.cache.getEndIndex(), lastIndexInSnapshot), Math.min(this.cache.getLastIndexInClosedSegments(), lastIndexInSnapshot), openSegmentFile);
    }

    @Override
    public long getStartIndex() {
        return this.cache.getStartIndex();
    }

    private void loadLogSegments(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> logConsumer) throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            List<RaftStorageDirectory.LogPathAndIndex> paths = this.storage.getStorageDir().getLogSegmentFiles();
            int i = 0;
            for (RaftStorageDirectory.LogPathAndIndex pi : paths) {
                boolean keepEntryInCache = paths.size() - i++ <= this.cache.getMaxCachedSegments();
                Timer.Context loadSegmentContext = this.getRaftLogMetrics().getRaftLogLoadSegmentTimer().time();
                this.cache.loadSegment(pi, keepEntryInCache, logConsumer, lastIndexInSnapshot);
                loadSegmentContext.stop();
            }
            if (!this.cache.isEmpty() && this.cache.getEndIndex() < lastIndexInSnapshot) {
                LOG.warn("End log index {} is smaller than last index in snapshot {}", (Object)this.cache.getEndIndex(), (Object)lastIndexInSnapshot);
                this.cache.clear();
            }
        }
    }

    @Override
    public RaftProtos.LogEntryProto get(long index) throws RaftLogIOException {
        LogSegment.LogRecord record;
        LogSegment segment;
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            segment = this.cache.getSegment(index);
            if (segment == null) {
                RaftProtos.LogEntryProto logEntryProto = null;
                return logEntryProto;
            }
            record = segment.getLogRecord(index);
            if (record == null) {
                RaftProtos.LogEntryProto logEntryProto = null;
                return logEntryProto;
            }
            RaftProtos.LogEntryProto entry = segment.getEntryFromCache(record.getTermIndex());
            if (entry != null) {
                this.getRaftLogMetrics().onRaftLogCacheHit();
                RaftProtos.LogEntryProto logEntryProto = entry;
                return logEntryProto;
            }
        }
        this.getRaftLogMetrics().onRaftLogCacheMiss();
        this.checkAndEvictCache();
        return segment.loadCache(record);
    }

    @Override
    public RaftLog.EntryWithData getEntryWithData(long index) throws RaftLogIOException {
        RaftProtos.LogEntryProto entry = this.get(index);
        if (entry == null) {
            throw new RaftLogIOException("Log entry not found: index = " + index);
        }
        if (!ServerProtoUtils.shouldReadStateMachineData(entry)) {
            return new RaftLog.EntryWithData(entry, null);
        }
        try {
            CompletionStage future = null;
            if (this.stateMachine != null) {
                future = this.stateMachine.data().read(entry).exceptionally(ex -> {
                    this.stateMachine.notifyLogFailed((Throwable)ex, entry);
                    return null;
                });
            }
            return new RaftLog.EntryWithData(entry, (CompletableFuture<ByteString>)future);
        }
        catch (Throwable e) {
            String err = this.getName() + ": Failed readStateMachineData for " + ServerProtoUtils.toLogEntryString(entry);
            LOG.error(err, e);
            throw new RaftLogIOException(err, JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    private void checkAndEvictCache() {
        if (this.server.shouldEvictCache()) {
            this.cache.evictCache(this.server.getFollowerNextIndices(), this.fileLogWorker.getSafeCacheEvictIndex(), this.server.getLastAppliedIndex());
        }
    }

    @Override
    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            LogSegment.LogRecord record = this.cache.getLogRecord(index);
            TermIndex termIndex = record != null ? record.getTermIndex() : null;
            return termIndex;
        }
    }

    @Override
    public TermIndex[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex[] termIndexArray = this.cache.getTermIndices(startIndex, endIndex);
            return termIndexArray;
        }
    }

    @Override
    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.cache.getLastTermIndex();
            return termIndex;
        }
    }

    @Override
    protected CompletableFuture<Long> truncateImpl(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.truncate(index);
            if (ts != null) {
                Task task = this.fileLogWorker.truncate(ts, index);
                CompletableFuture<Long> completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    @Override
    protected CompletableFuture<Long> purgeImpl(long index) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.purge(index);
            LOG.debug("purging segments:{}", (Object)ts);
            if (ts != null) {
                Task task = this.fileLogWorker.purge(ts);
                CompletableFuture<Long> completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected CompletableFuture<Long> appendEntryImpl(RaftProtos.LogEntryProto entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isSegmentFull(LogSegment segment, RaftProtos.LogEntryProto entry) {
        if (segment.getTotalSize() >= this.segmentMaxSize) {
            return true;
        }
        long entrySize = LogSegment.getEntrySize(entry);
        return entrySize <= this.segmentMaxSize && segment.getTotalSize() + entrySize > this.segmentMaxSize;
    }

    @Override
    public List<CompletableFuture<Long>> appendImpl(RaftProtos.LogEntryProto ... entries) {
        this.checkLogState();
        if (entries == null || entries.length == 0) {
            return Collections.emptyList();
        }
        try (AutoCloseableLock writeLock = this.writeLock();){
            ArrayList<CompletableFuture<Long>> futures;
            SegmentedRaftLogCache.TruncateIndices ti = this.cache.computeTruncateIndices(this.server::notifyTruncatedLogEntry, entries);
            long truncateIndex = ti.getTruncateIndex();
            int index = ti.getArrayIndex();
            LOG.debug("truncateIndex={}, arrayIndex={}", (Object)truncateIndex, (Object)index);
            if (truncateIndex != -1L) {
                futures = new ArrayList(entries.length - index + 1);
                futures.add(this.truncate(truncateIndex));
            } else {
                futures = new ArrayList<CompletableFuture<Long>>(entries.length - index);
            }
            for (int i = index; i < entries.length; ++i) {
                futures.add(this.appendEntry(entries[i]));
            }
            ArrayList<CompletableFuture<Long>> arrayList = futures;
            return arrayList;
        }
    }

    @Override
    public long getFlushIndex() {
        return this.fileLogWorker.getFlushIndex();
    }

    @Override
    public void writeMetadata(long term, RaftPeerId votedFor) throws IOException {
        this.storage.getMetaFile().set(term, votedFor != null ? votedFor.toString() : null);
    }

    @Override
    public RaftLog.Metadata loadMetadata() throws IOException {
        return new RaftLog.Metadata(RaftPeerId.getRaftPeerId((String)this.storage.getMetaFile().getVotedFor()), this.storage.getMetaFile().getTerm());
    }

    @Override
    public void syncWithSnapshot(long lastSnapshotIndex) {
        this.fileLogWorker.syncWithSnapshot(lastSnapshotIndex);
        LogSegment openSegment = this.cache.getOpenSegment();
        if (openSegment != null && openSegment.getEndIndex() <= lastSnapshotIndex) {
            this.fileLogWorker.closeLogSegment(openSegment);
            this.cache.clear();
        }
    }

    @Override
    public boolean isConfigEntry(TermIndex ti) {
        return this.cache.isConfigEntry(ti);
    }

    @Override
    public void close() throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            super.close();
            this.cache.clear();
        }
        this.fileLogWorker.close();
        this.storage.close();
        this.getRaftLogMetrics().unregister();
    }

    SegmentedRaftLogCache getRaftLogCache() {
        return this.cache;
    }

    @Override
    public String toString() {
        try (AutoCloseableLock readLock = this.readLock();){
            if (this.isOpened()) {
                String string = super.toString() + ",f" + this.getFlushIndex() + ",i" + Optional.ofNullable(this.getLastEntryTermIndex()).map(TermIndex::getIndex).orElse(0L);
                return string;
            }
            String string = super.toString();
            return string;
        }
    }

    @Override
    public String toLogEntryString(RaftProtos.LogEntryProto logEntry) {
        return ServerProtoUtils.toLogEntryString(logEntry, this.stateMachine::toStateMachineLogEntryString);
    }

    static interface ServerLogMethods {
        public static final ServerLogMethods DUMMY = new ServerLogMethods(){};

        default public boolean shouldEvictCache() {
            return false;
        }

        default public long[] getFollowerNextIndices() {
            return null;
        }

        default public long getLastAppliedIndex() {
            return -1L;
        }

        default public void notifyTruncatedLogEntry(TermIndex ti) {
        }
    }

    static abstract class Task {
        private final CompletableFuture<Long> future = new CompletableFuture();
        private Timer.Context queueTimerContext;

        Task() {
        }

        CompletableFuture<Long> getFuture() {
            return this.future;
        }

        void done() {
            this.completeFuture();
        }

        final void completeFuture() {
            boolean completed = this.future.complete(this.getEndIndex());
            Preconditions.assertTrue((boolean)completed, () -> this + " is already " + StringUtils.completableFuture2String(this.future, (boolean)false));
        }

        void failed(IOException e) {
            this.getFuture().completeExceptionally(e);
        }

        abstract void execute() throws IOException;

        abstract long getEndIndex();

        void startTimerOnEnqueue(Timer queueTimer) {
            this.queueTimerContext = queueTimer.time();
        }

        void stopTimerOnDequeue() {
            if (this.queueTimerContext != null) {
                this.queueTimerContext.stop();
            }
        }

        int getSerializedSize() {
            return 0;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.getEndIndex();
        }
    }
}

