/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoleInfo {
    public static final Logger LOG = LoggerFactory.getLogger(RoleInfo.class);
    private final RaftPeerId id;
    private volatile RaftProtos.RaftPeerRole role;
    private final AtomicReference<LeaderState> leaderState = new AtomicReference();
    private final AtomicReference<FollowerState> followerState = new AtomicReference();
    private final AtomicReference<LeaderElection> leaderElection = new AtomicReference();
    private final AtomicReference<Timestamp> transitionTime;

    RoleInfo(RaftPeerId id) {
        this.id = id;
        this.transitionTime = new AtomicReference<Timestamp>(Timestamp.currentTime());
    }

    RaftProtos.RaftPeerRole getRaftPeerRole() {
        return this.role;
    }

    void transitionRole(RaftProtos.RaftPeerRole newRole) {
        this.role = newRole;
        this.transitionTime.set(Timestamp.currentTime());
    }

    long getRoleElapsedTimeMs() {
        return this.transitionTime.get().elapsedTimeMs();
    }

    RaftProtos.RaftPeerRole getCurrentRole() {
        return this.role;
    }

    boolean isFollower() {
        return this.role == RaftProtos.RaftPeerRole.FOLLOWER;
    }

    boolean isCandidate() {
        return this.role == RaftProtos.RaftPeerRole.CANDIDATE;
    }

    boolean isLeader() {
        return this.role == RaftProtos.RaftPeerRole.LEADER;
    }

    Optional<LeaderState> getLeaderState() {
        return Optional.ofNullable(this.leaderState.get());
    }

    LeaderState getLeaderStateNonNull() {
        return Objects.requireNonNull(this.leaderState.get(), "leaderState is null");
    }

    RaftProtos.LogEntryProto startLeaderState(RaftServerImpl server, RaftProperties properties) {
        return this.updateAndGet(this.leaderState, new LeaderState(server, properties)).start();
    }

    void shutdownLeaderState(boolean allowNull) {
        LeaderState leader = this.leaderState.getAndSet(null);
        if (leader == null) {
            if (!allowNull) {
                throw new NullPointerException("leaderState == null");
            }
        } else {
            LOG.info("{}: shutdown {}", (Object)this.id, (Object)leader.getClass().getSimpleName());
            leader.stop();
        }
    }

    Optional<FollowerState> getFollowerState() {
        return Optional.ofNullable(this.followerState.get());
    }

    void startFollowerState(RaftServerImpl server) {
        this.updateAndGet(this.followerState, new FollowerState(server)).start();
    }

    void shutdownFollowerState() {
        FollowerState follower = this.followerState.getAndSet(null);
        if (follower != null) {
            LOG.info("{}: shutdown {}", (Object)this.id, (Object)((Object)((Object)follower)).getClass().getSimpleName());
            follower.stopRunning();
            follower.interrupt();
        }
    }

    void startLeaderElection(RaftServerImpl server) {
        this.updateAndGet(this.leaderElection, new LeaderElection(server)).start();
    }

    void shutdownLeaderElection() {
        LeaderElection election = this.leaderElection.getAndSet(null);
        if (election != null) {
            LOG.info("{}: shutdown {}", (Object)this.id, (Object)election.getClass().getSimpleName());
            election.shutdown();
        }
    }

    private <T> T updateAndGet(AtomicReference<T> ref, T current) {
        T updated = ref.updateAndGet(previous -> previous != null ? previous : current);
        Preconditions.assertTrue((updated == current ? 1 : 0) != 0, (Object)"previous != null");
        LOG.info("{}: start {}", (Object)this.id, (Object)current.getClass().getSimpleName());
        return updated;
    }

    public String toString() {
        return String.format("%9s", this.role);
    }
}

