/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.server;

import com.google.protobuf.BlockingService;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.ratis.hadooprpc.HadoopConfigKeys;
import org.apache.ratis.hadooprpc.Proxy;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolPB;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolServerSideTranslatorPB;
import org.apache.ratis.hadooprpc.server.RaftServerProtocolPB;
import org.apache.ratis.hadooprpc.server.RaftServerProtocolServerSideTranslatorPB;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.hadoop.HadoopCompatibilityProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.RaftServerRpcWithProxy;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.thirdparty.com.google.protobuf.GeneratedMessageV3;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopRpcService
extends RaftServerRpcWithProxy<Proxy<RaftServerProtocolPB>, PeerProxyMap<Proxy<RaftServerProtocolPB>>> {
    public static final Logger LOG = LoggerFactory.getLogger(HadoopRpcService.class);
    static final String CLASS_NAME = HadoopRpcService.class.getSimpleName();
    public static final String SEND_SERVER_REQUEST = CLASS_NAME + ".sendServerRequest";
    private final RPC.Server ipcServer;
    private final InetSocketAddress ipcServerAddress;

    public static Builder newBuilder() {
        return new Builder();
    }

    private HadoopRpcService(RaftServer server, Configuration conf) {
        super(() -> ((RaftServer)server).getId(), id -> new PeerProxyMap(id.toString(), p -> new Proxy<RaftServerProtocolPB>(RaftServerProtocolPB.class, p.getAddress(), conf)));
        try {
            this.ipcServer = HadoopRpcService.newRpcServer((RaftServerProtocol)server, conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create Hadoop rpc server.", e);
        }
        this.ipcServerAddress = this.ipcServer.getListenerAddress();
        this.addRaftClientProtocol(server, conf);
        LOG.info(((Object)((Object)this)).getClass().getSimpleName() + " created RPC.Server at " + this.ipcServerAddress);
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.HADOOP;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.ipcServerAddress;
    }

    private static RPC.Server newRpcServer(RaftServerProtocol serverProtocol, Configuration conf) throws IOException {
        int handlerCount = HadoopConfigKeys.Ipc.handlers(conf);
        InetSocketAddress address = HadoopConfigKeys.Ipc.address(conf);
        BlockingService service = HadoopCompatibilityProtos.HadoopServerProtocolService.newReflectiveBlockingService(new RaftServerProtocolServerSideTranslatorPB(serverProtocol));
        RPC.setProtocolEngine((Configuration)conf, RaftServerProtocolPB.class, ProtobufRpcEngine.class);
        return new RPC.Builder(conf).setProtocol(RaftServerProtocolPB.class).setInstance((Object)service).setBindAddress(address.getHostName()).setPort(address.getPort()).setNumHandlers(handlerCount).setVerbose(false).build();
    }

    private void addRaftClientProtocol(RaftServer server, Configuration conf) {
        Class<CombinedClientProtocolPB> protocol = CombinedClientProtocolPB.class;
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        BlockingService service = HadoopCompatibilityProtos.HadoopClientProtocolService.newReflectiveBlockingService(new CombinedClientProtocolServerSideTranslatorPB(server));
        this.ipcServer.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    public void startImpl() {
        this.ipcServer.start();
    }

    public void closeImpl() throws IOException {
        this.ipcServer.stop();
        super.closeImpl();
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        return (RaftProtos.AppendEntriesReplyProto)this.processRequest(request, request.getServerRequest().getReplyId(), HadoopCompatibilityProtos.ServerOps.appendEntries, RaftProtos.AppendEntriesReplyProto::parseFrom);
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        return (RaftProtos.InstallSnapshotReplyProto)this.processRequest(request, request.getServerRequest().getReplyId(), HadoopCompatibilityProtos.ServerOps.installSnapshot, RaftProtos.InstallSnapshotReplyProto::parseFrom);
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        return (RaftProtos.RequestVoteReplyProto)this.processRequest(request, request.getServerRequest().getReplyId(), HadoopCompatibilityProtos.ServerOps.requestVote, RaftProtos.RequestVoteReplyProto::parseFrom);
    }

    private <REQUEST extends GeneratedMessageV3, REPLY> REPLY processRequest(REQUEST request, org.apache.ratis.thirdparty.com.google.protobuf.ByteString replyId, HadoopCompatibilityProtos.ServerOps type, CheckedFunction<byte[], REPLY, InvalidProtocolBufferException> func) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        HadoopCompatibilityProtos.ServerRequestProto p = HadoopCompatibilityProtos.ServerRequestProto.newBuilder().setRequest(ByteString.copyFrom((byte[])request.toByteArray())).setType(type).build();
        RaftServerProtocolPB proxy = (RaftServerProtocolPB)((Proxy)this.getProxies().getProxy(RaftPeerId.valueOf((org.apache.ratis.thirdparty.com.google.protobuf.ByteString)replyId))).getProtocol();
        try {
            byte[] replyBytes = proxy.sendServer(null, p).getResponse().toByteArray();
            return (REPLY)func.apply((Object)replyBytes);
        }
        catch (Exception se) {
            throw new IOException(se);
        }
    }

    public static final class Builder
    extends RaftServerRpc.Builder<Builder, HadoopRpcService> {
        private Configuration conf;

        private Builder() {
        }

        public Configuration getConf() {
            if (this.conf == null) {
                this.conf = new Configuration();
            }
            return this.conf;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public HadoopRpcService build() {
            return new HadoopRpcService(this.getServer(), this.getConf());
        }
    }
}

