/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.hadooprpc.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.hadooprpc.client.CombinedClientProtocolPB;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.hadoop.HadoopCompatibilityProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.RaftServer;

@InterfaceAudience.Private
public class CombinedClientProtocolServerSideTranslatorPB
implements CombinedClientProtocolPB {
    private final RaftServer impl;

    public CombinedClientProtocolServerSideTranslatorPB(RaftServer impl) {
        this.impl = impl;
    }

    @Override
    public HadoopCompatibilityProtos.ClientReplyProto sendClient(RpcController unused, HadoopCompatibilityProtos.ClientRequestProto req) throws ServiceException {
        ByteBuffer buf = req.getRequest().asReadOnlyByteBuffer();
        RaftProtos.GroupInfoReplyProto response = null;
        HadoopCompatibilityProtos.ClientOps type = req.getType();
        try {
            switch (type) {
                case groupInfo: {
                    response = this.groupInfo(RaftProtos.GroupInfoRequestProto.parseFrom((ByteBuffer)buf));
                    break;
                }
                case groupList: {
                    response = this.groupList(RaftProtos.GroupListRequestProto.parseFrom((ByteBuffer)buf));
                    break;
                }
                case groupManagement: {
                    response = this.groupManagement(RaftProtos.GroupManagementRequestProto.parseFrom((ByteBuffer)buf));
                    break;
                }
                case setConfiguration: {
                    response = this.setConfiguration(RaftProtos.SetConfigurationRequestProto.parseFrom((ByteBuffer)buf));
                    break;
                }
                case submitClientRequest: {
                    response = this.submitClientRequest(RaftProtos.RaftClientRequestProto.parseFrom((ByteBuffer)buf));
                    break;
                }
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return HadoopCompatibilityProtos.ClientReplyProto.newBuilder().setType(type).setResponse(ByteString.copyFrom((byte[])response.toByteArray())).build();
    }

    public RaftProtos.RaftClientReplyProto submitClientRequest(RaftProtos.RaftClientRequestProto proto) throws IOException {
        RaftClientRequest request = ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)proto);
        RaftClientReply reply = this.impl.submitClientRequest(request);
        return ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply);
    }

    public RaftProtos.RaftClientReplyProto setConfiguration(RaftProtos.SetConfigurationRequestProto proto) throws IOException {
        SetConfigurationRequest request = ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)proto);
        RaftClientReply reply = this.impl.setConfiguration(request);
        return ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply);
    }

    public RaftProtos.RaftClientReplyProto groupManagement(RaftProtos.GroupManagementRequestProto proto) throws IOException {
        GroupManagementRequest request = ClientProtoUtils.toGroupManagementRequest((RaftProtos.GroupManagementRequestProto)proto);
        RaftClientReply reply = this.impl.groupManagement(request);
        return ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply);
    }

    public RaftProtos.GroupListReplyProto groupList(RaftProtos.GroupListRequestProto proto) throws IOException {
        GroupListRequest request = ClientProtoUtils.toGroupListRequest((RaftProtos.GroupListRequestProto)proto);
        GroupListReply reply = this.impl.getGroupList(request);
        return ClientProtoUtils.toGroupListReplyProto((GroupListReply)reply);
    }

    public RaftProtos.GroupInfoReplyProto groupInfo(RaftProtos.GroupInfoRequestProto proto) throws IOException {
        GroupInfoRequest request = ClientProtoUtils.toGroupInfoRequest((RaftProtos.GroupInfoRequestProto)proto);
        GroupInfoReply reply = this.impl.getGroupInfo(request);
        return ClientProtoUtils.toGroupInfoReplyProto((GroupInfoReply)reply);
    }
}

