/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc.netty;

import org.apache.ratis.thirdparty.io.grpc.Internal;
import org.apache.ratis.thirdparty.io.grpc.internal.ClientTransportFactory;
import org.apache.ratis.thirdparty.io.grpc.internal.SharedResourcePool;
import org.apache.ratis.thirdparty.io.grpc.netty.InternalProtocolNegotiator;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.netty.Utils;
import org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;

@Internal
public final class InternalNettyChannelBuilder {
    public static void overrideAuthorityChecker(NettyChannelBuilder channelBuilder, OverrideAuthorityChecker authorityChecker) {
        channelBuilder.overrideAuthorityChecker(authorityChecker);
    }

    public static void setProtocolNegotiatorFactory(NettyChannelBuilder builder, ProtocolNegotiatorFactory protocolNegotiator) {
        builder.protocolNegotiatorFactory(protocolNegotiator);
    }

    public static void setStatsEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setStatsEnabled(value);
    }

    public static void setTracingEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setTracingEnabled(value);
    }

    public static void setStatsRecordStartedRpcs(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordStartedRpcs(value);
    }

    public static void setStatsRecordRealTimeMetrics(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordRealTimeMetrics(value);
    }

    public static void useNioTransport(NettyChannelBuilder builder) {
        builder.channelType(NioSocketChannel.class);
        builder.eventLoopGroupPool(SharedResourcePool.forResource(Utils.NIO_WORKER_EVENT_LOOP_GROUP));
    }

    public static ClientTransportFactory buildTransportFactory(NettyChannelBuilder builder) {
        return builder.buildTransportFactory();
    }

    private InternalNettyChannelBuilder() {
    }

    public static interface ProtocolNegotiatorFactory
    extends NettyChannelBuilder.ProtocolNegotiatorFactory {
        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator();
    }

    public static interface OverrideAuthorityChecker
    extends NettyChannelBuilder.OverrideAuthorityChecker {
    }
}

