/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.Optional;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisMetrics {
    static final Logger LOG = LoggerFactory.getLogger(RatisMetrics.class);
    public static final String RATIS_APPLICATION_NAME_METRICS = "ratis";
    protected RatisMetricRegistry registry;

    protected RatisMetricRegistry create(MetricRegistryInfo info) {
        Optional<RatisMetricRegistry> metricRegistry = MetricRegistries.global().get(info);
        return metricRegistry.orElseGet(() -> {
            LOG.info("Creating Metrics Registry : {}", (Object)info.getName());
            return MetricRegistries.global().create(info);
        });
    }

    public void unregister() {
        MetricRegistryInfo info = this.registry.getMetricRegistryInfo();
        LOG.info("Unregistering Metrics Registry : {}", (Object)info.getName());
        Optional<RatisMetricRegistry> metricRegistry = MetricRegistries.global().get(info);
        if (metricRegistry.isPresent()) {
            MetricRegistries.global().remove(info);
        }
    }

    public RatisMetricRegistry getRegistry() {
        return this.registry;
    }
}

