/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Timer;
import java.util.function.LongSupplier;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.metrics.RatisMetrics;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.statemachine.StateMachine;

public final class StateMachineMetrics
extends RatisMetrics {
    public static final String RATIS_STATEMACHINE_METRICS = "state_machine";
    public static final String RATIS_STATEMACHINE_METRICS_DESC = "Metrics for State Machine Updater";
    public static final String STATEMACHINE_APPLIED_INDEX_GAUGE = "appliedIndex";
    public static final String STATEMACHINE_APPLY_COMPLETED_GAUGE = "applyCompletedIndex";
    public static final String STATEMACHINE_TAKE_SNAPSHOT_TIMER = "takeSnapshot";

    public static StateMachineMetrics getStateMachineMetrics(RaftServerImpl server, RaftLogIndex appliedIndex, StateMachine stateMachine) {
        String serverId = server.getMemberId().toString();
        LongSupplier getApplied = appliedIndex::get;
        LongSupplier getApplyCompleted = () -> stateMachine.getLastAppliedTermIndex() == null ? -1L : stateMachine.getLastAppliedTermIndex().getIndex();
        return new StateMachineMetrics(serverId, getApplied, getApplyCompleted);
    }

    private StateMachineMetrics(String serverId, LongSupplier getApplied, LongSupplier getApplyCompleted) {
        this.registry = this.getMetricRegistryForStateMachine(serverId);
        this.registry.gauge(STATEMACHINE_APPLIED_INDEX_GAUGE, () -> () -> getApplied.getAsLong());
        this.registry.gauge(STATEMACHINE_APPLY_COMPLETED_GAUGE, () -> () -> getApplyCompleted.getAsLong());
    }

    private RatisMetricRegistry getMetricRegistryForStateMachine(String serverId) {
        return this.create(new MetricRegistryInfo(serverId, "ratis", RATIS_STATEMACHINE_METRICS, RATIS_STATEMACHINE_METRICS_DESC));
    }

    public Timer getTakeSnapshotTimer() {
        return this.registry.timer(STATEMACHINE_TAKE_SNAPSHOT_TIMER);
    }
}

