/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FollowerState
extends Daemon {
    static final Logger LOG = LoggerFactory.getLogger(FollowerState.class);
    private final String name;
    private final RaftServerImpl server;
    private volatile Timestamp lastRpcTime = Timestamp.currentTime();
    private volatile boolean isRunning = true;
    private final AtomicInteger outstandingOp = new AtomicInteger();

    FollowerState(RaftServerImpl server) {
        this.name = server.getMemberId() + "-" + this.getClass().getSimpleName();
        this.server = server;
    }

    void updateLastRpcTime(UpdateType type) {
        this.lastRpcTime = Timestamp.currentTime();
        int n = type.update(this.outstandingOp);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: update lastRpcTime to {} for {}, outstandingOp={}", new Object[]{this, this.lastRpcTime, type, n});
        }
    }

    Timestamp getLastRpcTime() {
        return this.lastRpcTime;
    }

    int getOutstandingOp() {
        return this.outstandingOp.get();
    }

    boolean shouldWithholdVotes() {
        return this.lastRpcTime.elapsedTimeMs() < (long)this.server.getMinTimeoutMs();
    }

    void stopRunning() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long sleepDeviationThresholdMs = this.server.getSleepDeviationThresholdMs();
        while (this.isRunning && this.server.isFollower()) {
            long electionTimeout = this.server.getRandomTimeoutMs();
            try {
                if (!JavaUtils.sleep(electionTimeout, sleepDeviationThresholdMs)) continue;
                boolean isFollower = this.server.isFollower();
                if (!this.isRunning || !isFollower) {
                    LOG.info("{}: Stopping now (isRunning? {}, isFollower? {})", this, this.isRunning, isFollower);
                    break;
                }
                RaftServerImpl raftServerImpl = this.server;
                synchronized (raftServerImpl) {
                    if (this.outstandingOp.get() == 0 && this.lastRpcTime.elapsedTimeMs() >= electionTimeout) {
                        LOG.info("{}: change to CANDIDATE, lastRpcTime:{}ms, electionTimeout:{}ms", this, this.lastRpcTime.elapsedTimeMs(), electionTimeout);
                        this.server.getLeaderElectionMetrics().onLeaderElectionTimeout();
                        this.server.changeToCandidate();
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.info(this + " was interrupted: " + e);
                LOG.trace("TRACE", e);
                return;
            }
            catch (Exception e) {
                LOG.warn(this + " caught an exception", e);
            }
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    static enum UpdateType {
        APPEND_START(AtomicInteger::incrementAndGet),
        APPEND_COMPLETE(AtomicInteger::decrementAndGet),
        INSTALL_SNAPSHOT_START(AtomicInteger::incrementAndGet),
        INSTALL_SNAPSHOT_COMPLETE(AtomicInteger::decrementAndGet),
        INSTALL_SNAPSHOT_NOTIFICATION(AtomicInteger::get),
        REQUEST_VOTE(AtomicInteger::get);

        private final ToIntFunction<AtomicInteger> updateFunction;

        private UpdateType(ToIntFunction<AtomicInteger> updateFunction) {
            this.updateFunction = updateFunction;
        }

        int update(AtomicInteger outstanding) {
            return this.updateFunction.applyAsInt(outstanding);
        }
    }
}

