/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;

public class ConfigurationManager {
    private final RaftConfiguration initialConf;
    private final NavigableMap<Long, RaftConfiguration> configurations = new TreeMap<Long, RaftConfiguration>();
    private RaftConfiguration currentConf;

    ConfigurationManager(RaftConfiguration initialConf) {
        this.initialConf = initialConf;
        this.currentConf = initialConf;
    }

    synchronized void addConfiguration(long logIndex, RaftConfiguration conf) {
        RaftConfiguration found = (RaftConfiguration)this.configurations.get(logIndex);
        if (found != null) {
            Preconditions.assertTrue(found.equals(conf));
            return;
        }
        this.configurations.put(logIndex, conf);
        if (logIndex == this.configurations.lastEntry().getKey()) {
            this.currentConf = conf;
        }
    }

    synchronized RaftConfiguration getCurrent() {
        return this.currentConf;
    }

    synchronized RaftConfiguration removeConfigurations(long index) {
        SortedMap<Long, RaftConfiguration> toRemove = this.configurations.tailMap(index);
        Iterator<Map.Entry<Long, RaftConfiguration>> iter = toRemove.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        this.currentConf = this.configurations.isEmpty() ? this.initialConf : this.configurations.lastEntry().getValue();
        return this.currentConf;
    }

    synchronized int numOfConf() {
        return 1 + this.configurations.size();
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + ", init=" + this.initialConf + ", confs=" + StringUtils.map2String(this.configurations);
    }
}

