/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipleLinearRandomRetry
implements RetryPolicy {
    static final Logger LOG = LoggerFactory.getLogger(MultipleLinearRandomRetry.class);
    private final List<Pair> pairs;
    private final Supplier<String> myString;

    private MultipleLinearRandomRetry(List<Pair> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            throw new IllegalArgumentException("pairs must be neither null nor empty.");
        }
        this.pairs = Collections.unmodifiableList(pairs);
        this.myString = JavaUtils.memoize(() -> this.getClass().getSimpleName() + pairs);
    }

    @Override
    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        Pair p = this.searchPair(event.getAttemptCount());
        return p == null ? NO_RETRY_ACTION : p::getRandomSleepTime;
    }

    private Pair searchPair(int curRetry) {
        int i;
        for (i = 0; i < this.pairs.size() && curRetry > this.pairs.get(i).numRetries; curRetry -= this.pairs.get(i).numRetries, ++i) {
        }
        return i == this.pairs.size() ? null : this.pairs.get(i);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.toString().equals(that.toString());
    }

    public String toString() {
        return this.myString.get();
    }

    public static MultipleLinearRandomRetry parseCommaSeparated(String input) {
        String[] elements = input.split(",");
        if (elements.length == 0) {
            LOG.warn("Illegal value: there is no element in \"{}\".", (Object)input);
            return null;
        }
        if (elements.length % 2 != 0) {
            LOG.warn("Illegal value: the number of elements in \"{}\" is {} but an even number of elements is expected.", (Object)input, (Object)elements.length);
            return null;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        int i = 0;
        while (i < elements.length) {
            Integer retries;
            TimeDuration sleep;
            if ((sleep = MultipleLinearRandomRetry.parseElement(elements, i++, input, MultipleLinearRandomRetry::parsePositiveTime)) == null) {
                return null;
            }
            if ((retries = MultipleLinearRandomRetry.parseElement(elements, i++, input, MultipleLinearRandomRetry::parsePositiveInt)) == null) {
                return null;
            }
            pairs.add(new Pair(retries, sleep));
        }
        return new MultipleLinearRandomRetry(pairs);
    }

    private static TimeDuration parsePositiveTime(String s2) {
        TimeDuration t = TimeDuration.valueOf(s2, TimeUnit.MILLISECONDS);
        if (t.isNonPositive()) {
            throw new IllegalArgumentException("Non-positive value: " + t);
        }
        return t;
    }

    private static int parsePositiveInt(String trimmed) {
        int n = Integer.parseInt(trimmed);
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive value: " + n);
        }
        return n;
    }

    private static <E> E parseElement(String[] elements, int i, String input, Function<String, E> parser) {
        String s2 = elements[i].trim().replace("_", "");
        try {
            return parser.apply(s2);
        }
        catch (Throwable t) {
            LOG.warn("Failed to parse \"{}\", which is the index {} element in \"{}\"", s2, i, input, t);
            return null;
        }
    }

    private static class Pair {
        private final int numRetries;
        private final TimeDuration sleepTime;

        Pair(int numRetries, TimeDuration sleepTime) {
            if (numRetries < 0) {
                throw new IllegalArgumentException("numRetries = " + numRetries + " < 0");
            }
            if (sleepTime.isNegative()) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime + " < 0");
            }
            this.numRetries = numRetries;
            this.sleepTime = sleepTime;
        }

        TimeDuration getRandomSleepTime() {
            double ratio = ThreadLocalRandom.current().nextDouble() + 0.5;
            return this.sleepTime.multiply(ratio);
        }

        public String toString() {
            return this.numRetries + "x" + this.sleepTime;
        }
    }
}

