/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Collection;
import java.util.Collections;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AlreadyClosedException;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public class RaftClientReply
extends RaftClientMessage {
    private final boolean success;
    private final long callId;
    private final RaftException exception;
    private final Message message;
    private final long logIndex;
    private final Collection<RaftProtos.CommitInfoProto> commitInfos;

    public RaftClientReply(ClientId clientId, RaftGroupMemberId serverId, long callId, boolean success, Message message, RaftException exception, long logIndex, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this(clientId, serverId.getPeerId(), serverId.getGroupId(), callId, success, message, exception, logIndex, commitInfos);
    }

    public RaftClientReply(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, boolean success, Message message, RaftException exception, long logIndex, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        super(clientId, serverId, groupId);
        this.success = success;
        this.callId = callId;
        this.message = message;
        this.exception = exception;
        this.logIndex = logIndex;
        Collection<RaftProtos.CommitInfoProto> collection = this.commitInfos = commitInfos != null ? commitInfos : Collections.emptyList();
        if (exception != null) {
            Preconditions.assertTrue(!success, () -> "Inconsistent parameters: success && exception != null: " + this);
            Preconditions.assertTrue(ReflectionUtils.isInstance(exception, AlreadyClosedException.class, NotLeaderException.class, NotReplicatedException.class, LeaderNotReadyException.class, StateMachineException.class), () -> "Unexpected exception class: " + this);
        }
    }

    public RaftClientReply(RaftClientRequest request, RaftException exception, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this(request.getClientId(), request.getServerId(), request.getRaftGroupId(), request.getCallId(), false, null, exception, 0L, commitInfos);
    }

    public RaftClientReply(RaftClientRequest request, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this(request, (Message)null, commitInfos);
    }

    public RaftClientReply(RaftClientRequest request, Message message, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this(request.getClientId(), request.getServerId(), request.getRaftGroupId(), request.getCallId(), true, message, null, 0L, commitInfos);
    }

    public RaftClientReply(RaftClientRequest request, NotReplicatedException nre, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this(request.getClientId(), request.getServerId(), request.getRaftGroupId(), request.getCallId(), false, request.getMessage(), nre, nre.getLogIndex(), commitInfos);
    }

    public Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        return this.commitInfos;
    }

    @Override
    public final boolean isRequest() {
        return false;
    }

    public long getCallId() {
        return this.callId;
    }

    public long getLogIndex() {
        return this.logIndex;
    }

    @Override
    public String toString() {
        return super.toString() + ", cid=" + this.getCallId() + ", " + (this.isSuccess() ? "SUCCESS" : "FAILED " + this.exception) + ", logIndex=" + this.getLogIndex() + ", commits" + ProtoUtils.toString(this.commitInfos);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Message getMessage() {
        return this.message;
    }

    public AlreadyClosedException getAlreadyClosedException() {
        return JavaUtils.cast(this.exception, AlreadyClosedException.class);
    }

    public NotLeaderException getNotLeaderException() {
        return JavaUtils.cast(this.exception, NotLeaderException.class);
    }

    public NotReplicatedException getNotReplicatedException() {
        return JavaUtils.cast(this.exception, NotReplicatedException.class);
    }

    public StateMachineException getStateMachineException() {
        return JavaUtils.cast(this.exception, StateMachineException.class);
    }

    public LeaderNotReadyException getLeaderNotReadyException() {
        return JavaUtils.cast(this.exception, LeaderNotReadyException.class);
    }

    public RaftException getException() {
        return this.exception;
    }
}

