/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.RaftServerRpcWithProxy;
import org.apache.ratis.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.ratis.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufDecoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufEncoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ProtoUtils;

public final class NettyRpcService
extends RaftServerRpcWithProxy<NettyRpcProxy, NettyRpcProxy.PeerMap> {
    static final String CLASS_NAME = NettyRpcService.class.getSimpleName();
    public static final String SEND_SERVER_REQUEST = CLASS_NAME + ".sendServerRequest";
    private final RaftServer server;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final ChannelFuture channelFuture;

    public static Builder newBuilder() {
        return new Builder();
    }

    private NettyRpcService(RaftServer server) {
        super(server::getId, (RaftPeerId id) -> new NettyRpcProxy.PeerMap(id.toString()));
        this.server = server;
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ProtobufVarint32FrameDecoder());
                p.addLast(new ProtobufDecoder(NettyProtos.RaftNettyServerRequestProto.getDefaultInstance()));
                p.addLast(new ProtobufVarint32LengthFieldPrepender());
                p.addLast(new ProtobufEncoder());
                p.addLast(new InboundHandler());
            }
        };
        int port = NettyConfigKeys.Server.port(server.getProperties());
        this.channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(initializer).bind(port);
    }

    @Override
    public SupportedRpcType getRpcType() {
        return SupportedRpcType.NETTY;
    }

    private Channel getChannel() {
        return this.channelFuture.awaitUninterruptibly().channel();
    }

    @Override
    public void startImpl() throws IOException {
        try {
            this.channelFuture.syncUninterruptibly();
        }
        catch (Throwable t) {
            throw new IOException(this.getId() + ": Failed to start " + this.getClass().getSimpleName(), t);
        }
    }

    @Override
    public void closeImpl() throws IOException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        ChannelFuture f = this.getChannel().close();
        super.closeImpl();
        f.syncUninterruptibly();
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return (InetSocketAddress)this.getChannel().localAddress();
    }

    NettyProtos.RaftNettyServerReplyProto handle(NettyProtos.RaftNettyServerRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpcRequest = null;
        try {
            switch (proto.getRaftNettyServerRequestCase()) {
                case REQUESTVOTEREQUEST: {
                    RaftProtos.RequestVoteRequestProto request = proto.getRequestVoteRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRequestVoteReply(reply).build();
                }
                case APPENDENTRIESREQUEST: {
                    RaftProtos.AppendEntriesRequestProto request = proto.getAppendEntriesRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.AppendEntriesReplyProto reply = this.server.appendEntries(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setAppendEntriesReply(reply).build();
                }
                case INSTALLSNAPSHOTREQUEST: {
                    RaftProtos.InstallSnapshotRequestProto request = proto.getInstallSnapshotRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.InstallSnapshotReplyProto reply = this.server.installSnapshot(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setInstallSnapshotReply(reply).build();
                }
                case RAFTCLIENTREQUEST: {
                    RaftProtos.RaftClientRequestProto request = proto.getRaftClientRequest();
                    rpcRequest = request.getRpcRequest();
                    RaftClientReply reply = this.server.submitClientRequest(ClientProtoUtils.toRaftClientRequest(request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(reply)).build();
                }
                case SETCONFIGURATIONREQUEST: {
                    RaftProtos.SetConfigurationRequestProto request = proto.getSetConfigurationRequest();
                    rpcRequest = request.getRpcRequest();
                    RaftClientReply reply = this.server.setConfiguration(ClientProtoUtils.toSetConfigurationRequest(request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(reply)).build();
                }
                case GROUPMANAGEMENTREQUEST: {
                    RaftProtos.GroupManagementRequestProto request = proto.getGroupManagementRequest();
                    rpcRequest = request.getRpcRequest();
                    RaftClientReply reply = this.server.groupManagement(ClientProtoUtils.toGroupManagementRequest(request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(reply)).build();
                }
                case GROUPLISTREQUEST: {
                    RaftProtos.GroupListRequestProto request = proto.getGroupListRequest();
                    rpcRequest = request.getRpcRequest();
                    GroupListReply reply = this.server.getGroupList(ClientProtoUtils.toGroupListRequest(request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupListReply(ClientProtoUtils.toGroupListReplyProto(reply)).build();
                }
                case GROUPINFOREQUEST: {
                    RaftProtos.GroupInfoRequestProto request = proto.getGroupInfoRequest();
                    rpcRequest = request.getRpcRequest();
                    GroupInfoReply reply = this.server.getGroupInfo(ClientProtoUtils.toGroupInfoRequest(request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupInfoReply(ClientProtoUtils.toGroupInfoReplyProto(reply)).build();
                }
                case RAFTNETTYSERVERREQUEST_NOT_SET: {
                    throw new IllegalArgumentException("Request case not set in proto: " + proto.getRaftNettyServerRequestCase());
                }
            }
            throw new UnsupportedOperationException("Request case not supported: " + proto.getRaftNettyServerRequestCase());
        }
        catch (IOException ioe) {
            return NettyRpcService.toRaftNettyServerReplyProto(Objects.requireNonNull(rpcRequest, "rpcRequest = null"), ioe);
        }
    }

    private static NettyProtos.RaftNettyServerReplyProto toRaftNettyServerReplyProto(RaftProtos.RaftRpcRequestProto request, IOException e) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(request.getRequestorId()).setReplyId(request.getReplyId()).setCallId(request.getCallId()).setSuccess(false);
        NettyProtos.RaftNettyExceptionReplyProto.Builder ioe = NettyProtos.RaftNettyExceptionReplyProto.newBuilder().setRpcReply(rpcReply).setException(ProtoUtils.writeObject2ByteString(e));
        return NettyProtos.RaftNettyServerReplyProto.newBuilder().setExceptionReply(ioe).build();
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(SEND_SERVER_REQUEST, this.getId(), null, request);
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setRequestVoteRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getRequestVoteReply();
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(SEND_SERVER_REQUEST, this.getId(), null, request);
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setAppendEntriesRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getAppendEntriesReply();
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(SEND_SERVER_REQUEST, this.getId(), null, request);
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setInstallSnapshotRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getInstallSnapshotReply();
    }

    private NettyProtos.RaftNettyServerReplyProto sendRaftNettyServerRequestProto(RaftProtos.RaftRpcRequestProto request, NettyProtos.RaftNettyServerRequestProto proto) throws IOException {
        RaftPeerId id = RaftPeerId.valueOf(request.getReplyId());
        try {
            NettyRpcProxy p = (NettyRpcProxy)((NettyRpcProxy.PeerMap)this.getProxies()).getProxy(id);
            return p.send(request, proto);
        }
        catch (Exception e) {
            ((NettyRpcProxy.PeerMap)this.getProxies()).handleException(id, e, false);
            throw e;
        }
    }

    @ChannelHandler.Sharable
    class InboundHandler
    extends SimpleChannelInboundHandler<NettyProtos.RaftNettyServerRequestProto> {
        InboundHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, NettyProtos.RaftNettyServerRequestProto proto) {
            NettyProtos.RaftNettyServerReplyProto reply = NettyRpcService.this.handle(proto);
            ctx.writeAndFlush(reply);
        }
    }

    public static class Builder
    extends RaftServerRpc.Builder<Builder, NettyRpcService> {
        private Builder() {
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public NettyRpcService build() {
            return new NettyRpcService(this.getServer());
        }
    }
}

