/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class RefCountingMap<K, V> {
    private ConcurrentHashMap<K, Payload<V>> map = new ConcurrentHashMap();

    RefCountingMap() {
    }

    V put(K k, Supplier<V> supplier) {
        return (V)this.map.compute(k, (k1, oldValue) -> {
            if (oldValue != null) {
                ((Payload)oldValue).refCount++;
                return oldValue;
            }
            return new Payload(supplier.get());
        }).v;
    }

    V get(K k) {
        Payload<V> p = this.map.get(k);
        return (V)(p == null ? null : ((Payload)p).v);
    }

    V remove(K k) {
        Payload p = this.map.computeIfPresent(k, (k1, v) -> --((Payload)v).refCount <= 0 ? null : v);
        return (V)(p == null ? null : p.v);
    }

    void clear() {
        this.map.clear();
    }

    Set<K> keySet() {
        return this.map.keySet();
    }

    Collection<V> values() {
        return this.map.values().stream().map(v -> ((Payload)v).v).collect(Collectors.toList());
    }

    int size() {
        return this.map.size();
    }

    private static class Payload<V> {
        private V v;
        private int refCount;

        Payload(V v) {
            this.v = v;
            this.refCount = 1;
        }
    }
}

