/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.SortedMap;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;

public class RatisMetricRegistryImpl
implements RatisMetricRegistry {
    private MetricRegistry metricRegistry = new MetricRegistry();
    private final MetricRegistryInfo info;

    public RatisMetricRegistryImpl(MetricRegistryInfo info) {
        this.info = info;
    }

    @Override
    public Timer timer(String name) {
        return this.metricRegistry.timer(this.getMetricName(name));
    }

    @Override
    public Counter counter(String name) {
        return this.metricRegistry.counter(this.getMetricName(name));
    }

    @Override
    public Gauge gauge(String name, MetricRegistry.MetricSupplier<Gauge> supplier) {
        return this.metricRegistry.gauge(this.getMetricName(name), supplier);
    }

    @Override
    public Timer timer(String name, MetricRegistry.MetricSupplier<Timer> supplier) {
        return this.metricRegistry.timer(this.getMetricName(name), supplier);
    }

    @Override
    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.metricRegistry.getGauges(filter);
    }

    @Override
    public Counter counter(String name, MetricRegistry.MetricSupplier<Counter> supplier) {
        return this.metricRegistry.counter(this.getMetricName(name), supplier);
    }

    @Override
    public Histogram histogram(String name) {
        return this.metricRegistry.histogram(this.getMetricName(name));
    }

    @Override
    public Meter meter(String name) {
        return this.metricRegistry.meter(this.getMetricName(name));
    }

    @Override
    public Meter meter(String name, MetricRegistry.MetricSupplier<Meter> supplier) {
        return this.metricRegistry.meter(this.getMetricName(name), supplier);
    }

    @Override
    @VisibleForTesting
    public Metric get(String shortName) {
        return this.metricRegistry.getMetrics().get(this.getMetricName(shortName));
    }

    private String getMetricName(String shortName) {
        return MetricRegistry.name(this.info.getName(), shortName);
    }

    @Override
    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.metricRegistry.register(this.getMetricName(name), metric);
    }

    @Override
    public MetricRegistry getDropWizardMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }

    @Override
    public void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.register(prefix + "." + entry.getKey(), entry.getValue());
        }
    }
}

