/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.io.nativeio;

import java.io.IOException;
import org.apache.ratis.io.nativeio.Errno;
import org.apache.ratis.util.PlatformUtils;

public class NativeIOException
extends IOException {
    private static final long serialVersionUID = 1L;
    private Errno errno;
    private int errorCode;

    public NativeIOException(String msg, Errno errno) {
        super(msg);
        this.errno = errno;
        this.errorCode = 0;
    }

    public NativeIOException(String msg, int errorCode) {
        super(msg);
        this.errorCode = errorCode;
        this.errno = Errno.UNKNOWN;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public Errno getErrno() {
        return this.errno;
    }

    @Override
    public String toString() {
        if (PlatformUtils.WINDOWS) {
            return this.errorCode + ": " + super.getMessage();
        }
        return this.errno.toString() + ": " + super.getMessage();
    }
}

