/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NegotiationType;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServerProtocolClient
implements Closeable {
    private final ManagedChannel channel;
    private final TimeDuration requestTimeoutDuration;
    private final RaftServerProtocolServiceGrpc.RaftServerProtocolServiceBlockingStub blockingStub;
    private final RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub asyncStub;
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServerProtocolClient.class);

    public GrpcServerProtocolClient(RaftPeer target, int flowControlWindow, TimeDuration requestTimeoutDuration, GrpcTlsConfig tlsConfig) {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget(target.getAddress());
        if (tlsConfig != null) {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (tlsConfig.isFileBasedConfig()) {
                sslContextBuilder.trustManager(tlsConfig.getTrustStoreFile());
            } else {
                sslContextBuilder.trustManager(tlsConfig.getTrustStore());
            }
            if (tlsConfig.getMtlsEnabled()) {
                if (tlsConfig.isFileBasedConfig()) {
                    sslContextBuilder.keyManager(tlsConfig.getCertChainFile(), tlsConfig.getPrivateKeyFile());
                } else {
                    sslContextBuilder.keyManager(tlsConfig.getPrivateKey(), tlsConfig.getCertChain());
                }
            }
            try {
                channelBuilder.useTransportSecurity().sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to build SslContext, tlsConfig=" + tlsConfig, ex);
            }
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        this.channel = channelBuilder.flowControlWindow(flowControlWindow).build();
        this.blockingStub = RaftServerProtocolServiceGrpc.newBlockingStub(this.channel);
        this.asyncStub = RaftServerProtocolServiceGrpc.newStub(this.channel);
        this.requestTimeoutDuration = requestTimeoutDuration;
    }

    @Override
    public void close() {
        this.channel.shutdown();
        try {
            this.channel.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception while waiting for channel termination", e);
        }
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) {
        RaftProtos.RequestVoteReplyProto r = ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).requestVote(request);
        return r;
    }

    StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(StreamObserver<RaftProtos.AppendEntriesReplyProto> responseHandler) {
        return this.asyncStub.appendEntries(responseHandler);
    }

    StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseHandler) {
        return ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub)this.asyncStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).installSnapshot(responseHandler);
    }
}

