/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.metrics.GrpcServerMetrics;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcLogAppender
extends LogAppender {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcLogAppender.class);
    private final GrpcService rpcService;
    private final RequestMap pendingRequests = new RequestMap();
    private final int maxPendingRequestsNum;
    private long callId = 0L;
    private volatile boolean firstResponseReceived = false;
    private final boolean installSnapshotEnabled;
    private final TimeDuration requestTimeoutDuration;
    private final TimeoutScheduler scheduler = TimeoutScheduler.getInstance();
    private volatile StreamObserver<RaftProtos.AppendEntriesRequestProto> appendLogRequestObserver;
    private final GrpcServerMetrics grpcServerMetrics;

    public GrpcLogAppender(RaftServerImpl server, LeaderState leaderState, FollowerInfo f) {
        super(server, leaderState, f);
        this.rpcService = (GrpcService)server.getServerRpc();
        this.maxPendingRequestsNum = GrpcConfigKeys.Server.leaderOutstandingAppendsMax(server.getProxy().getProperties());
        this.requestTimeoutDuration = RaftServerConfigKeys.Rpc.requestTimeout(server.getProxy().getProperties());
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled(server.getProxy().getProperties());
        this.grpcServerMetrics = new GrpcServerMetrics(server.getMemberId().toString());
        this.grpcServerMetrics.addPendingRequestsCount(server.getMemberId().toString(), () -> this.pendingRequests.logRequestsSize());
    }

    private GrpcServerProtocolClient getClient() throws IOException {
        return (GrpcServerProtocolClient)((PeerProxyMap)this.rpcService.getProxies()).getProxy(this.getFollowerId());
    }

    private synchronized void resetClient(AppendEntriesRequest request) {
        ((PeerProxyMap)this.rpcService.getProxies()).resetProxy(this.getFollowerId());
        this.appendLogRequestObserver = null;
        this.firstResponseReceived = false;
        long nextIndex = 1L + Optional.ofNullable(request).map(AppendEntriesRequest::getPreviousLog).map(TermIndex::getIndex).orElseGet(this.follower::getMatchIndex);
        this.pendingRequests.clear();
        this.follower.decreaseNextIndex(nextIndex);
    }

    @Override
    protected void runAppenderImpl() throws IOException {
        while (this.isAppenderRunning()) {
            boolean shouldAppendLog = true;
            if (this.shouldSendRequest()) {
                if (this.installSnapshotEnabled) {
                    SnapshotInfo snapshot = this.shouldInstallSnapshot();
                    if (snapshot != null) {
                        this.installSnapshot(snapshot);
                        shouldAppendLog = false;
                    }
                } else {
                    TermIndex installSnapshotNotificationTermIndex = this.shouldNotifyToInstallSnapshot();
                    if (installSnapshotNotificationTermIndex != null) {
                        this.installSnapshot(installSnapshotNotificationTermIndex);
                        shouldAppendLog = false;
                    }
                }
                if (this.shouldHeartbeat() || shouldAppendLog && !this.shouldWait()) {
                    this.appendLog();
                }
            }
            this.checkSlowness();
            this.mayWait();
        }
        Optional.ofNullable(this.appendLogRequestObserver).ifPresent(StreamObserver::onCompleted);
    }

    private long getWaitTimeMs() {
        if (!this.shouldSendRequest()) {
            return this.getHeartbeatRemainingTime();
        }
        if (this.shouldWait()) {
            return this.halfMinTimeoutMs;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayWait() {
        long waitTimeMs = this.getWaitTimeMs();
        if (waitTimeMs <= 0L) {
            return;
        }
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            try {
                LOG.trace("{}: wait {}ms", (Object)this, (Object)waitTimeMs);
                this.wait(waitTimeMs);
            }
            catch (InterruptedException ie) {
                LOG.warn(this + ": Wait interrupted by " + ie);
            }
        }
    }

    @Override
    protected boolean shouldSendRequest() {
        return this.appendLogRequestObserver == null || super.shouldSendRequest();
    }

    private boolean shouldWait() {
        int size = this.pendingRequests.logRequestsSize();
        if (size == 0) {
            return false;
        }
        return !this.firstResponseReceived || size >= this.maxPendingRequestsNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLog() throws IOException {
        StreamObserver<RaftProtos.AppendEntriesRequestProto> s2;
        AppendEntriesRequest request;
        RaftProtos.AppendEntriesRequestProto pending;
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            pending = this.createRequest(this.callId++);
            if (pending == null) {
                return;
            }
            this.grpcServerMetrics.onRequestCreate();
            request = new AppendEntriesRequest(pending, this.grpcServerMetrics.getGrpcLogAppenderLatencyTimer(this.getFollowerId().toString()));
            this.pendingRequests.put(request);
            this.increaseNextIndex(pending);
            if (this.appendLogRequestObserver == null) {
                this.appendLogRequestObserver = this.getClient().appendEntries(new AppendLogResponseHandler());
            }
            s2 = this.appendLogRequestObserver;
        }
        if (this.isAppenderRunning()) {
            this.sendRequest(request, pending, s2);
        }
    }

    private void sendRequest(AppendEntriesRequest request, RaftProtos.AppendEntriesRequestProto proto, StreamObserver<RaftProtos.AppendEntriesRequestProto> s2) {
        CodeInjectionForTesting.execute(GrpcService.GRPC_SEND_SERVER_REQUEST, this.server.getId(), null, proto);
        request.startRequestTimer();
        s2.onNext(proto);
        this.scheduler.onTimeout(this.requestTimeoutDuration, () -> this.timeoutAppendRequest(request.getCallId(), request.isHeartbeat()), LOG, () -> "Timeout check failed for append entry request: " + request);
        this.follower.updateLastRpcSendTime();
    }

    private void timeoutAppendRequest(long cid, boolean heartbeat) {
        AppendEntriesRequest pending = this.pendingRequests.handleTimeout(cid, heartbeat);
        if (pending != null) {
            LOG.warn("{}: {} appendEntries Timeout, request={}", this, heartbeat ? "HEARTBEAT" : "", pending);
            this.grpcServerMetrics.onRequestTimeout(this.getFollowerId().toString());
        }
    }

    private void increaseNextIndex(RaftProtos.AppendEntriesRequestProto request) {
        int count = request.getEntriesCount();
        if (count > 0) {
            this.follower.increaseNextIndex(request.getEntries(count - 1).getIndex() + 1L);
        }
    }

    private synchronized void updateNextIndex(long replyNextIndex) {
        this.pendingRequests.clear();
        this.follower.updateNextIndex(replyNextIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSnapshot(SnapshotInfo snapshot) {
        LOG.info("{}: followerNextIndex = {} but logStartIndex = {}, send snapshot {} to follower", this, this.follower.getNextIndex(), this.raftLog.getStartIndex(), snapshot);
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler();
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        String requestId = UUID.randomUUID().toString();
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(responseHandler);
            for (RaftProtos.InstallSnapshotRequestProto request : new LogAppender.SnapshotRequestIter(snapshot, requestId)) {
                if (!this.isAppenderRunning()) break;
                snapshotRequestObserver.onNext(request);
                this.follower.updateLastRpcSendTime();
                responseHandler.addPending(request);
            }
            snapshotRequestObserver.onCompleted();
            this.grpcServerMetrics.onInstallSnapshot();
        }
        catch (Exception e) {
            LOG.warn("{}: failed to install snapshot {}: {}", this, snapshot.getFiles(), e);
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError(e);
            }
            return;
        }
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            while (this.isAppenderRunning() && !responseHandler.isDone()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (responseHandler.hasAllResponse()) {
            this.follower.setSnapshotIndex(snapshot.getTermIndex().getIndex());
            LOG.info("{}: installed snapshot {} successfully", (Object)this, (Object)snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSnapshot(TermIndex firstAvailableLogTermIndex) {
        LOG.info("{}: followerNextIndex = {} but logStartIndex = {}, notify follower to install snapshot-{}", this, this.follower.getNextIndex(), this.raftLog.getStartIndex(), firstAvailableLogTermIndex);
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler();
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        RaftProtos.InstallSnapshotRequestProto request = this.createInstallSnapshotNotificationRequest(firstAvailableLogTermIndex);
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: send {}", (Object)this, (Object)ServerProtoUtils.toString(request));
        }
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(responseHandler);
            snapshotRequestObserver.onNext(request);
            this.follower.updateLastRpcSendTime();
            responseHandler.addPending(request);
            snapshotRequestObserver.onCompleted();
        }
        catch (Exception e) {
            GrpcUtil.warn(LOG, () -> this + ": Failed to notify follower to install snapshot.", e);
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError(e);
            }
            return;
        }
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            if (this.isAppenderRunning() && !responseHandler.isDone()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private TermIndex shouldNotifyToInstallSnapshot() {
        if (this.follower.getNextIndex() < this.raftLog.getStartIndex()) {
            return this.raftLog.getTermIndex(this.raftLog.getStartIndex());
        }
        return null;
    }

    static class RequestMap {
        private final Map<Long, AppendEntriesRequest> logRequests = new ConcurrentHashMap<Long, AppendEntriesRequest>();
        private final Map<Long, AppendEntriesRequest> heartbeats = new ConcurrentHashMap<Long, AppendEntriesRequest>();

        RequestMap() {
        }

        int logRequestsSize() {
            return this.logRequests.size();
        }

        void clear() {
            this.logRequests.clear();
            this.heartbeats.clear();
        }

        void put(AppendEntriesRequest request) {
            if (request.isHeartbeat()) {
                this.heartbeats.put(request.getCallId(), request);
            } else {
                this.logRequests.put(request.getCallId(), request);
            }
        }

        AppendEntriesRequest remove(RaftProtos.AppendEntriesReplyProto reply) {
            return this.remove(reply.getServerReply().getCallId(), reply.getIsHearbeat());
        }

        AppendEntriesRequest remove(long cid, boolean isHeartbeat) {
            return isHeartbeat ? this.heartbeats.remove(cid) : this.logRequests.remove(cid);
        }

        public AppendEntriesRequest handleTimeout(long callId, boolean heartbeat) {
            return heartbeat ? this.heartbeats.remove(callId) : this.logRequests.get(callId);
        }
    }

    static class AppendEntriesRequest {
        private final Timer timer;
        private volatile Timer.Context timerContext;
        private final long callId;
        private final TermIndex previousLog;
        private final int entriesCount;
        private final TermIndex lastEntry;

        AppendEntriesRequest(RaftProtos.AppendEntriesRequestProto proto, Timer timer) {
            this.callId = proto.getServerRequest().getCallId();
            this.previousLog = proto.hasPreviousLog() ? ServerProtoUtils.toTermIndex(proto.getPreviousLog()) : null;
            this.entriesCount = proto.getEntriesCount();
            this.lastEntry = this.entriesCount > 0 ? ServerProtoUtils.toTermIndex(proto.getEntries(this.entriesCount - 1)) : null;
            this.timer = timer;
        }

        long getCallId() {
            return this.callId;
        }

        TermIndex getPreviousLog() {
            return this.previousLog;
        }

        void startRequestTimer() {
            this.timerContext = this.timer.time();
        }

        void stopRequestTimer() {
            this.timerContext.stop();
        }

        boolean isHeartbeat() {
            return this.entriesCount == 0;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":cid=" + this.callId + ",entriesCount=" + this.entriesCount + ",lastEntry=" + this.lastEntry;
        }
    }

    private class InstallSnapshotResponseHandler
    implements StreamObserver<RaftProtos.InstallSnapshotReplyProto> {
        private final String name;
        private final Queue<Integer> pending;
        private final AtomicBoolean done;

        InstallSnapshotResponseHandler() {
            this.name = GrpcLogAppender.this.follower.getName() + "-" + this.getClass().getSimpleName();
            this.done = new AtomicBoolean(false);
            this.pending = new LinkedList<Integer>();
        }

        synchronized void addPending(RaftProtos.InstallSnapshotRequestProto request) {
            this.pending.offer(request.getSnapshotChunk().getRequestIndex());
        }

        synchronized void removePending(RaftProtos.InstallSnapshotReplyProto reply) {
            Integer index = this.pending.poll();
            Objects.requireNonNull(index, "index == null");
            Preconditions.assertTrue(index.intValue() == reply.getRequestIndex());
        }

        boolean isDone() {
            return this.done.get();
        }

        void close() {
            this.done.set(true);
            GrpcLogAppender.this.notifyAppend();
        }

        synchronized boolean hasAllResponse() {
            return this.pending.isEmpty();
        }

        @Override
        public void onNext(RaftProtos.InstallSnapshotReplyProto reply) {
            if (LOG.isInfoEnabled()) {
                LOG.info("{}: received {} reply {}", this, GrpcLogAppender.this.firstResponseReceived ? "a" : "the first", ServerProtoUtils.toString(reply));
            }
            GrpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GrpcLogAppender.this.firstResponseReceived) {
                GrpcLogAppender.this.firstResponseReceived = true;
            }
            switch (reply.getResult()) {
                case SUCCESS: 
                case IN_PROGRESS: {
                    this.removePending(reply);
                    break;
                }
                case ALREADY_INSTALLED: {
                    long followerSnapshotIndex = reply.getSnapshotIndex();
                    LOG.info("{}: set follower snapshotIndex to {}.", (Object)this, (Object)followerSnapshotIndex);
                    GrpcLogAppender.this.follower.setSnapshotIndex(followerSnapshotIndex);
                    this.removePending(reply);
                    break;
                }
                case NOT_LEADER: {
                    GrpcLogAppender.this.checkResponseTerm(reply.getTerm());
                    break;
                }
                case CONF_MISMATCH: {
                    LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", this, "raft.server.log.appender.install.snapshot.enabled", GrpcLogAppender.this.server.getId(), GrpcLogAppender.this.installSnapshotEnabled, GrpcLogAppender.this.getFollowerId(), !GrpcLogAppender.this.installSnapshotEnabled);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isAppenderRunning()) {
                LOG.info("{} is stopped", (Object)this);
                return;
            }
            LOG.error("{}: Failed installSnapshot: {}", (Object)this, (Object)t);
            GrpcLogAppender.this.resetClient(null);
            this.close();
        }

        @Override
        public void onCompleted() {
            LOG.info("{}: follower responses installSnapshot COMPLETED", (Object)this);
            this.close();
        }

        public String toString() {
            return this.name;
        }
    }

    private class AppendLogResponseHandler
    implements StreamObserver<RaftProtos.AppendEntriesReplyProto> {
        private final String name;

        private AppendLogResponseHandler() {
            this.name = GrpcLogAppender.this.follower.getName() + "-" + this.getClass().getSimpleName();
        }

        @Override
        public void onNext(RaftProtos.AppendEntriesReplyProto reply) {
            AppendEntriesRequest request = GrpcLogAppender.this.pendingRequests.remove(reply);
            if (request != null) {
                request.stopRequestTimer();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: received {} reply {}, request={}", this, GrpcLogAppender.this.firstResponseReceived ? "a" : "the first", ServerProtoUtils.toString(reply), request);
            }
            try {
                this.onNextImpl(reply);
            }
            catch (Throwable t) {
                LOG.error("Failed onNext request=" + request + ", reply=" + ServerProtoUtils.toString(reply), t);
            }
        }

        private void onNextImpl(RaftProtos.AppendEntriesReplyProto reply) {
            GrpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GrpcLogAppender.this.firstResponseReceived) {
                GrpcLogAppender.this.firstResponseReceived = true;
            }
            switch (reply.getResult()) {
                case SUCCESS: {
                    GrpcLogAppender.this.grpcServerMetrics.onRequestSuccess(GrpcLogAppender.this.getFollowerId().toString());
                    GrpcLogAppender.this.updateCommitIndex(reply.getFollowerCommit());
                    if (!GrpcLogAppender.this.follower.updateMatchIndex(reply.getMatchIndex())) break;
                    GrpcLogAppender.this.submitEventOnSuccessAppend();
                    break;
                }
                case NOT_LEADER: {
                    GrpcLogAppender.this.grpcServerMetrics.onRequestNotLeader(GrpcLogAppender.this.getFollowerId().toString());
                    if (!GrpcLogAppender.this.checkResponseTerm(reply.getTerm())) break;
                    return;
                }
                case INCONSISTENCY: {
                    GrpcLogAppender.this.grpcServerMetrics.onRequestInconsistency(GrpcLogAppender.this.getFollowerId().toString());
                    GrpcLogAppender.this.updateNextIndex(reply.getNextIndex());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected reply result: " + reply.getResult());
                }
            }
            GrpcLogAppender.this.notifyAppend();
        }

        @Override
        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isAppenderRunning()) {
                LOG.info("{} is stopped", (Object)GrpcLogAppender.this);
                return;
            }
            GrpcUtil.warn(LOG, () -> this + ": Failed appendEntries", t);
            GrpcLogAppender.this.grpcServerMetrics.onRequestRetry();
            AppendEntriesRequest request = GrpcLogAppender.this.pendingRequests.remove(GrpcUtil.getCallId(t), GrpcUtil.isHeartbeat(t));
            GrpcLogAppender.this.resetClient(request);
        }

        @Override
        public void onCompleted() {
            LOG.info("{}: follower responses appendEntries COMPLETED", (Object)this);
            GrpcLogAppender.this.resetClient(null);
        }

        public String toString() {
            return this.name;
        }
    }
}

